/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUnit {
    private static DocumentBuilderFactory controlBuilderFactory;
    private static DocumentBuilderFactory testBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static boolean ignoreWhitespace;
    private static final String STRIP_WHITESPACE_STYLESHEET;

    private XMLUnit() {
    }

    public static void setControlParser(String string) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", string);
        controlBuilderFactory = null;
        controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
    }

    public static DocumentBuilder getControlParser() throws ParserConfigurationException {
        controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
        return controlBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilderFactory getControlDocumentBuilderFactory() {
        if (controlBuilderFactory == null) {
            controlBuilderFactory = DocumentBuilderFactory.newInstance();
            controlBuilderFactory.setNamespaceAware(true);
        }
        return controlBuilderFactory;
    }

    public static void setControlDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        if (documentBuilderFactory == null) {
            throw new IllegalArgumentException("Cannot set control DocumentBuilderFactory to null!");
        }
        controlBuilderFactory = documentBuilderFactory;
    }

    public static void setTestParser(String string) throws FactoryConfigurationError {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", string);
        testBuilderFactory = null;
        testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
    }

    public static DocumentBuilder getTestParser() throws ParserConfigurationException {
        testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
        return testBuilderFactory.newDocumentBuilder();
    }

    public static DocumentBuilderFactory getTestDocumentBuilderFactory() {
        if (testBuilderFactory == null) {
            testBuilderFactory = DocumentBuilderFactory.newInstance();
            testBuilderFactory.setNamespaceAware(true);
        }
        return testBuilderFactory;
    }

    public static void setTestDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        if (documentBuilderFactory == null) {
            throw new IllegalArgumentException("Cannot set test DocumentBuilderFactory to null!");
        }
        testBuilderFactory = documentBuilderFactory;
    }

    public static void setIgnoreWhitespace(boolean bl) {
        ignoreWhitespace = bl;
        XMLUnit.getControlDocumentBuilderFactory().setIgnoringElementContentWhitespace(bl);
        XMLUnit.getTestDocumentBuilderFactory().setIgnoringElementContentWhitespace(bl);
    }

    public static boolean getIgnoreWhitespace() {
        return ignoreWhitespace;
    }

    public static Diff compare(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, reader2);
    }

    public static Diff compare(String string, Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(new StringReader(string), reader);
    }

    public static Diff compare(Reader reader, String string) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(reader, new StringReader(string));
    }

    public static Diff compare(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        return new Diff(string, string2);
    }

    public static Document buildControlDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getControlParser(), new StringReader(string));
    }

    public static Document buildTestDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.buildDocument(XMLUnit.getTestParser(), new StringReader(string));
    }

    protected static Document buildDocument(DocumentBuilder documentBuilder, Reader reader) throws SAXException, IOException {
        return documentBuilder.parse(new InputSource(reader));
    }

    public static void setTransformerFactory(String string) throws TransformerFactoryConfigurationError {
        System.setProperty("javax.xml.transform.TransformerFactory", string);
        transformerFactory = null;
        XMLUnit.getTransformerFactory();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static void setSAXParserFactory(String string) {
        System.setProperty("javax.xml.parsers.SAXParserFactory", string);
        XMLUnit.getSAXParserFactory();
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    public static Transform getStripWhitespaceTransform(Document document) throws TransformerConfigurationException {
        return new Transform((Node)document, STRIP_WHITESPACE_STYLESHEET);
    }

    public static String getVersion() {
        return "0.8";
    }

    static {
        ignoreWhitespace = false;
        STRIP_WHITESPACE_STYLESHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">" + "<xsl:output method=\"xml\" version=\"1.0\" indent=\"no\"/>" + "<xsl:strip-space elements=\"*\"/>" + "<xsl:template match=\"/\"><xsl:copy-of select=\".\"/></xsl:template>" + "</xsl:stylesheet>";
    }
}

