/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.custommonkey.xmlunit.DoctypeReader;
import org.custommonkey.xmlunit.NodeInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Validator
extends DefaultHandler
implements ErrorHandler {
    private final InputSource validationInputSource;
    private final SAXParser parser;
    private final StringBuffer messages = new StringBuffer();
    private final boolean usingDoctypeReader;
    private Boolean isValid = null;

    protected Validator(InputSource inputSource, boolean bl) throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = XMLUnit.getSAXParserFactory();
        sAXParserFactory.setValidating(true);
        this.parser = sAXParserFactory.newSAXParser();
        this.validationInputSource = inputSource;
        this.usingDoctypeReader = bl;
    }

    public Validator(Document document, String string, String string2) throws ParserConfigurationException, SAXException {
        this(new InputStreamReader(new NodeInputStream(document)), string, string2);
    }

    public Validator(Reader reader) throws ParserConfigurationException, SAXException {
        this(new InputSource(reader), reader instanceof DoctypeReader);
    }

    public Validator(Reader reader, String string) throws ParserConfigurationException, SAXException {
        this(reader);
        this.validationInputSource.setSystemId(string);
    }

    public Validator(Reader reader, String string, String string2) throws ParserConfigurationException, SAXException {
        this(new DoctypeReader(reader, string2, string));
        this.validationInputSource.setSystemId(string);
    }

    public boolean isValid() {
        this.validate();
        return this.isValid;
    }

    public StringBuffer appendMessage(StringBuffer stringBuffer) {
        if (this.isValid()) {
            return stringBuffer.append("[valid]");
        }
        return stringBuffer.append((Object)this.messages);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append(':');
        return this.appendMessage(stringBuffer).toString();
    }

    private void validate() {
        if (this.isValid != null) {
            return;
        }
        try {
            this.parser.parse(this.validationInputSource, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.parserException(sAXException);
        }
        catch (IOException iOException) {
            this.parserException(iOException);
        }
        if (this.isValid == null) {
            this.isValid = Boolean.TRUE;
        } else if (this.usingDoctypeReader) {
            try {
                this.messages.append("\nContent was: ").append(((DoctypeReader)this.validationInputSource.getCharacterStream()).getContent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parserException(Exception exception) {
        this.invalidate(exception.getMessage());
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.errorHandlerException(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errorHandlerException(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorHandlerException(sAXParseException);
    }

    public InputSource resolveEntity(String string, String string2) {
        if (this.validationInputSource.getSystemId() != null) {
            return new InputSource(this.validationInputSource.getSystemId());
        }
        if (string2 != null) {
            return new InputSource(string2);
        }
        return null;
    }

    private void errorHandlerException(Exception exception) {
        this.invalidate(exception.getMessage());
    }

    private void invalidate(String string) {
        this.isValid = Boolean.FALSE;
        this.messages.append(string).append(' ');
    }
}

