/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Transform {
    private static final File PWD = new File(".");
    private final Source inputSource;
    private final Transformer transformer;

    public Transform(String string, String string2) throws TransformerConfigurationException {
        this(new StreamSource(new StringReader(string)), (Source)new StreamSource(new StringReader(string2)));
    }

    public Transform(String string, File file) throws TransformerConfigurationException {
        this(new StreamSource(new StringReader(string)), (Source)new StreamSource(file));
    }

    public Transform(Node node) throws TransformerConfigurationException {
        this(node, (Source)null);
    }

    public Transform(Node node, String string) throws TransformerConfigurationException {
        this(node, (Source)new StreamSource(new StringReader(string)));
    }

    public Transform(Node node, File file) throws TransformerConfigurationException {
        this(node, (Source)new StreamSource(file));
    }

    private Transform(Node node, Source source) throws TransformerConfigurationException {
        this(new DOMSource(node), source);
    }

    public Transform(Source source, Source source2) throws TransformerConfigurationException {
        this.inputSource = source;
        this.provideSystemIdIfRequired(source);
        this.provideSystemIdIfRequired(source2);
        this.transformer = this.getTransformer(source2);
    }

    private void provideSystemIdIfRequired(Source source) {
        if (source != null && (source.getSystemId() == null || source.getSystemId().length() == 0)) {
            source.setSystemId(this.getDefaultSystemId());
        }
    }

    private String getDefaultSystemId() {
        try {
            return PWD.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unable to determine current working directory!");
        }
    }

    private Transformer getTransformer(Source source) throws TransformerConfigurationException {
        TransformerFactory transformerFactory = XMLUnit.getTransformerFactory();
        if (source == null) {
            return transformerFactory.newTransformer();
        }
        return transformerFactory.newTransformer(source);
    }

    protected void transformTo(Result result) throws TransformerException {
        this.transformer.transform(this.inputSource, result);
    }

    public String getResultString() throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        this.transformTo(new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public Document getResultDocument() throws TransformerException {
        DOMResult dOMResult = new DOMResult();
        this.transformTo(dOMResult);
        return (Document)dOMResult.getNode();
    }

    public void setOutputProperty(String string, String string2) {
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        this.setOutputProperties(properties);
    }

    public void setOutputProperties(Properties properties) {
        this.transformer.setOutputProperties(properties);
    }

    public void setParameter(String string, Object object) {
        this.transformer.setParameter(string, object);
    }

    public Object getParameter(String string) {
        return this.transformer.getParameter(string);
    }

    public void clearParameters() {
        this.transformer.clearParameters();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.transformer.setURIResolver(uRIResolver);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.transformer.setErrorListener(errorListener);
    }
}

