/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TolerantSaxDocumentBuilder
extends DefaultHandler
implements LexicalHandler {
    private final DocumentBuilder documentBuilder;
    private final StringBuffer traceBuffer;
    private Document currentDocument;
    private Element currentElement;

    public TolerantSaxDocumentBuilder(DocumentBuilder documentBuilder) throws ParserConfigurationException {
        this.documentBuilder = documentBuilder;
        this.traceBuffer = new StringBuffer();
    }

    public Document getDocument() {
        return this.currentDocument;
    }

    public String getTrace() {
        return this.traceBuffer.toString();
    }

    public void startDocument() throws SAXException {
        this.traceBuffer.delete(0, this.traceBuffer.length());
        this.trace("startDocument");
        this.currentDocument = this.documentBuilder.newDocument();
        this.currentElement = null;
    }

    public void endDocument() throws SAXException {
        this.trace("endDocument");
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        this.trace("characters:" + string);
        if (this.currentElement == null) {
            this.warn("Can't append text node to null currentElement");
        } else {
            Text text = this.currentDocument.createTextNode(string);
            this.currentElement.appendChild(text);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.trace("startElement:" + string2 + "~" + string3);
        Element element = this.createElement(string, string3, attributes);
        this.appendNode(element);
        this.currentElement = element;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.trace("endElement:" + string2 + "~" + string3);
        if (this.currentElement == null) {
            this.warn(string3 + ": endElement before any startElement");
            return;
        }
        Node node = null;
        boolean bl = false;
        boolean bl2 = false;
        Element element = this.currentElement;
        while (!bl2 && !bl) {
            node = this.currentElement.getParentNode();
            if (node.getNodeType() == 1) {
                bl2 = this.isElementMatching(this.currentElement, string3);
                this.currentElement = (Element)node;
                continue;
            }
            if (node.getNodeType() == 9) {
                bl = true;
                if (element == this.currentDocument.getDocumentElement()) {
                    bl2 = this.isElementMatching(element, string3);
                    continue;
                }
                this.currentElement = element;
                continue;
            }
            throw new IllegalArgumentException("Closing element " + string3 + ": expecting a parent ELEMENT_NODE but found " + node);
        }
        if (!bl2) {
            this.warn(string3 + ": endElement does not match startElement!");
        }
    }

    private boolean isElementMatching(Element element, String string) {
        return element.getNodeName() != null && element.getNodeName().equals(string);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.unhandled("endPrefixMapping");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.unhandled("ignorableWhitespace");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.trace("processingInstruction");
        ProcessingInstruction processingInstruction = this.currentDocument.createProcessingInstruction(string, string2);
        this.appendNode(processingInstruction);
    }

    public void setDocumentLocator(Locator locator) {
        this.unhandled("setDocumentLocator");
    }

    public void skippedEntity(String string) throws SAXException {
        this.unhandled("skippedEntity");
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.unhandled("startPrefixMapping");
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.unhandled("startDTD");
    }

    public void endDTD() throws SAXException {
        this.unhandled("endDTD");
    }

    public void startEntity(String string) throws SAXException {
        this.unhandled("startEntity");
    }

    public void endEntity(String string) throws SAXException {
        this.unhandled("endEntity");
    }

    public void startCDATA() throws SAXException {
        this.unhandled("startCDATA");
    }

    public void endCDATA() throws SAXException {
        this.unhandled("endCDATA");
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.trace("comment:" + string);
        Comment comment = this.currentDocument.createComment(string);
        this.appendNode(comment);
    }

    private void unhandled(String string) {
        this.trace("Unhandled callback: " + string);
    }

    private void warn(String string) {
        this.trace("WARNING: " + string);
    }

    private void trace(String string) {
        this.traceBuffer.append(string).append('\n');
    }

    private Element createElement(String string, String string2, Attributes attributes) {
        Element element = this.currentDocument.createElement(string2);
        if (string != null && string.length() > 0) {
            element.setPrefix(string);
        }
        int n = 0;
        while (attributes != null && n < attributes.getLength()) {
            element.setAttribute(attributes.getQName(n), attributes.getValue(n));
            ++n;
        }
        return element;
    }

    private void appendNode(Node node) {
        if (this.currentElement == null) {
            this.currentDocument.appendChild(node);
        } else {
            this.currentElement.appendChild(node);
        }
    }
}

