/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleXpathEngine
implements XSLTConstants {
    private StringBuffer getXSLTBase() {
        return new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">");
    }

    private String getCopyTransformation(String string) {
        return this.getXSLTBase().append("<xsl:preserve-space elements=\"*\"/>").append("<xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\"/>").append("<xsl:template match=\"/\">").append("<xpathResult>").append("<xsl:apply-templates select=\"").append(string).append("\" mode=\"result\"/>").append("</xpathResult>").append("</xsl:template>").append("<xsl:template match=\"*\" mode=\"result\">").append("  <xsl:copy-of select=\".\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private String getValueTransformation(String string) {
        return this.getXSLTBase().append("<xsl:output method=\"text\"/>").append("<xsl:template match=\"/\">").append("  <xsl:value-of select=\"").append(string).append("\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private void performTransform(String string, Document document, Result result) throws TransformerConfigurationException, TransformerException {
        StreamSource streamSource = new StreamSource(new StringReader(string));
        Transformer transformer = XMLUnit.getTransformerFactory().newTransformer(streamSource);
        transformer.transform(new DOMSource(document), result);
    }

    protected Node getXPathResultNode(String string, Document document) throws TransformerException {
        return this.getXPathResultAsDocument(string, document).getDocumentElement();
    }

    protected Document getXPathResultAsDocument(String string, Document document) throws TransformerException {
        DOMResult dOMResult = new DOMResult();
        this.performTransform(this.getCopyTransformation(string), document, dOMResult);
        return (Document)dOMResult.getNode();
    }

    public NodeList getMatchingNodes(String string, Document document) throws TransformerException, TransformerConfigurationException {
        return this.getXPathResultNode(string, document).getChildNodes();
    }

    public String evaluate(String string, Document document) throws TransformerException, TransformerConfigurationException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        this.performTransform(this.getValueTransformation(string), document, streamResult);
        return stringWriter.toString();
    }
}

