/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class NodeTest {
    private final DocumentTraversal documentTraversal;
    private final Node rootNode;

    public NodeTest(String string) throws SAXException, ParserConfigurationException, IOException {
        this(new StringReader(string));
    }

    public NodeTest(Reader reader) throws SAXException, ParserConfigurationException, IOException {
        this(XMLUnit.buildDocument(XMLUnit.getControlParser(), reader));
    }

    public NodeTest(Document document) {
        this(NodeTest.getDocumentTraversal(document), document.getDocumentElement());
    }

    private static DocumentTraversal getDocumentTraversal(Document document) {
        try {
            return (DocumentTraversal)((Object)document);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("DOM Traversal not supported by " + document.getImplementation().getClass().getName() + ". To use this class you will need to switch to a DOM implementation that supports Traversal.");
        }
    }

    public NodeTest(DocumentTraversal documentTraversal, Node node) {
        this.documentTraversal = documentTraversal;
        this.rootNode = node;
    }

    public void performTest(NodeTester nodeTester, short s) throws NodeTestException {
        this.performTest(nodeTester, new short[]{s});
    }

    public void performTest(NodeTester nodeTester, short[] sArray) throws NodeTestException {
        NodeIterator nodeIterator = this.documentTraversal.createNodeIterator(this.rootNode, -1, new NodeTypeNodeFilter(sArray), true);
        Node node = nodeIterator.nextNode();
        while (node != null) {
            nodeTester.testNode(node, this);
            node = nodeIterator.nextNode();
        }
        nodeTester.noMoreNodes(this);
    }

    private class NodeTypeNodeFilter
    implements NodeFilter {
        private final short[] nodeTypes;

        public NodeTypeNodeFilter(short[] sArray) {
            this.nodeTypes = sArray;
        }

        public short acceptNode(Node node) {
            if (this.acceptNodeType(node.getNodeType())) {
                return 1;
            }
            return 2;
        }

        private boolean acceptNodeType(short s) {
            int n = 0;
            while (n < this.nodeTypes.length) {
                if (this.nodeTypes[n] == s) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

