/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.custommonkey.xmlunit.TolerantSaxDocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLDocumentBuilder {
    protected final TolerantSaxDocumentBuilder tolerantSaxDocumentBuilder;
    protected final SwingEvent2SaxAdapter swingEvent2SaxAdapter;
    private final StringBuffer traceBuffer;

    public HTMLDocumentBuilder(TolerantSaxDocumentBuilder tolerantSaxDocumentBuilder) {
        this.tolerantSaxDocumentBuilder = tolerantSaxDocumentBuilder;
        this.swingEvent2SaxAdapter = new SwingEvent2SaxAdapter();
        this.traceBuffer = new StringBuffer();
    }

    public Document parse(Reader reader) throws SAXException, IOException {
        this.traceBuffer.delete(0, this.traceBuffer.length());
        this.swingEvent2SaxAdapter.parse(reader, this.tolerantSaxDocumentBuilder);
        this.traceBuffer.append(this.tolerantSaxDocumentBuilder.getTrace());
        return this.tolerantSaxDocumentBuilder.getDocument();
    }

    public Document parse(String string) throws SAXException, IOException {
        return this.parse(new StringReader(string));
    }

    public String getTrace() {
        return this.traceBuffer.toString();
    }

    private void trace(String string) {
        this.traceBuffer.append(string).append('\n');
    }

    public class SwingEvent2SaxAdapter
    extends HTMLEditorKit.ParserCallback {
        private final boolean IGNORE_HTML_CHAR_SET = true;
        private final AttributesImpl attributes = new AttributesImpl();
        private final ParserDelegator delegator = new ParserDelegator();
        private boolean lastTagWasSimpleTag;
        private ContentHandler saxContentHandler;
        private SAXException firstUnhandledException;

        public void parse(Reader reader, ContentHandler contentHandler) throws SAXException, IOException {
            this.saxContentHandler = contentHandler;
            this.preParse();
            this.delegator.parse(reader, this, true);
            this.postParse();
        }

        private void preParse() throws SAXException {
            this.firstUnhandledException = null;
            this.saxContentHandler.startDocument();
        }

        private void postParse() throws SAXException {
            try {
                this.saxContentHandler.endDocument();
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
            if (this.firstUnhandledException != null) {
                throw this.firstUnhandledException;
            }
        }

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
            try {
                int n2 = this.lastTagWasSimpleTag ? this.getStartIgnoringClosingSimpleTag(cArray) : 0;
                if (n2 < cArray.length) {
                    this.saxContentHandler.characters(cArray, n2, cArray.length);
                }
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }

        private int getStartIgnoringClosingSimpleTag(char[] cArray) {
            if (cArray[0] == '>') {
                return 1;
            }
            return 0;
        }

        public void handleComment(char[] cArray, int n) {
            if (this.saxContentHandler instanceof LexicalHandler) {
                try {
                    ((LexicalHandler)((Object)this.saxContentHandler)).comment(cArray, 0, cArray.length);
                }
                catch (SAXException sAXException) {
                    this.handleSAXException(sAXException);
                }
            } else {
                HTMLDocumentBuilder.this.trace("Unhandled comment " + new String(cArray));
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            try {
                this.saxContentHandler.startElement("", "", tag.toString(), this.convertToSaxAttributes(mutableAttributeSet));
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
            this.lastTagWasSimpleTag = false;
        }

        public void handleEndTag(HTML.Tag tag, int n) {
            try {
                this.saxContentHandler.endElement("", "", tag.toString());
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            this.handleStartTag(tag, mutableAttributeSet, n);
            this.handleEndTag(tag, n);
            this.lastTagWasSimpleTag = true;
        }

        public void handleError(String string, int n) {
            HTMLDocumentBuilder.this.trace("HTML ERROR: " + string);
        }

        private Attributes convertToSaxAttributes(MutableAttributeSet mutableAttributeSet) {
            this.attributes.clear();
            Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = mutableAttributeSet.getAttribute(obj);
                this.attributes.addAttribute("", "", obj.toString(), "CDATA", object.toString());
            }
            return this.attributes;
        }

        private void handleSAXException(SAXException sAXException) {
            HTMLDocumentBuilder.this.trace("SAX Error: " + sAXException.getMessage());
            if (this.firstUnhandledException == null) {
                this.firstUnhandledException = sAXException;
            }
        }
    }
}

