/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class DoctypeReader
extends Reader {
    private static final String DOCTYPE_OPEN_DECL = "<!";
    private static final int DECL_LENGTH = "<!".length();
    private static final String DOCTYPE_CLOSE_DECL = ">";
    private static final String DOCTYPE = "DOCTYPE ";
    private static final String SYSTEM = " SYSTEM \"";
    private final Reader originalSource;
    private final StringBuffer sourceBuffer = new StringBuffer(1024);
    private final String doctypeName;
    private final String systemId;
    private Reader replacementReader;

    public DoctypeReader(Reader reader, String string, String string2) {
        this.originalSource = reader;
        this.doctypeName = string;
        this.systemId = string2;
    }

    protected String getContent() throws IOException {
        return this.getContent(this.originalSource).toString();
    }

    private StringBuffer getContent(Reader reader) throws IOException {
        if (this.sourceBuffer.length() == 0) {
            String string;
            BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String string2 = System.getProperty("line.separator");
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    bl = false;
                } else {
                    this.sourceBuffer.append(string2);
                }
                this.sourceBuffer.append(string);
            }
            bufferedReader.close();
        }
        return this.sourceBuffer;
    }

    private int findStartDoctype(StringBuffer stringBuffer) {
        int n = -1;
        boolean bl = true;
        int n2 = 0;
        while (n == -1) {
            char c = stringBuffer.charAt(n2);
            if (c == '<') {
                switch (stringBuffer.charAt(n2 + 1)) {
                    case '!': 
                    case '-': 
                    case '?': {
                        bl = false;
                        break;
                    }
                    default: {
                        n = n2;
                        break;
                    }
                }
            } else if (c == '>') {
                bl = true;
            } else if (bl) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public String replaceDoctype(StringBuffer stringBuffer, String string, String string2) {
        int n;
        String string3 = stringBuffer.toString();
        int n2 = string3.indexOf(DOCTYPE);
        boolean bl = false;
        if (n2 == -1) {
            n2 = this.findStartDoctype(stringBuffer);
            bl = true;
        }
        int n3 = n2 + DOCTYPE.length();
        if (bl) {
            stringBuffer.insert(n2, DOCTYPE_OPEN_DECL);
            stringBuffer.insert(n2 + DECL_LENGTH, DOCTYPE);
            n3 += DECL_LENGTH;
        } else {
            n = string3.indexOf(91, n3);
            if (n > 0) {
                int n4 = string3.indexOf(93, n);
                stringBuffer.delete(n3, n4 + 1);
            } else {
                int n5 = string3.indexOf(62, n3);
                stringBuffer.delete(n3, n5);
            }
        }
        n = n3;
        stringBuffer.insert(n, string);
        stringBuffer.insert(n += string.length(), SYSTEM);
        stringBuffer.insert(n += SYSTEM.length(), string2);
        stringBuffer.insert(n += string2.length(), '\"');
        if (bl) {
            stringBuffer.insert(++n, DOCTYPE_CLOSE_DECL);
        }
        return stringBuffer.toString();
    }

    private Reader getReplacementReader() throws IOException {
        StringBuffer stringBuffer = this.getContent(this.originalSource);
        String string = this.replaceDoctype(stringBuffer, this.doctypeName, this.systemId);
        return new StringReader(string);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.replacementReader == null) {
            this.replacementReader = this.getReplacementReader();
        }
        return this.replacementReader.read(cArray, n, n2);
    }

    public void close() throws IOException {
        this.replacementReader.close();
    }
}

