/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DifferenceEngine
implements DifferenceConstants {
    private static final String NULL_NODE = "null";
    private static final String NOT_NULL_NODE = "not null";
    private DifferenceFoundException flowControlException = new DifferenceFoundException();

    public void compare(Node node, Node node2, DifferenceListener differenceListener) {
        try {
            this.compare(this.getNullOrNotNull(node), this.getNullOrNotNull(node2), node, node2, differenceListener, DifferenceConstants.NODE_TYPE);
            if (node != null) {
                this.compareNode(node, node2, differenceListener);
            }
        }
        catch (DifferenceFoundException differenceFoundException) {
            // empty catch block
        }
    }

    private String getNullOrNotNull(Node node) {
        return node == null ? NULL_NODE : NOT_NULL_NODE;
    }

    protected void compareNode(Node node, Node node2, DifferenceListener differenceListener) throws DifferenceFoundException {
        boolean bl = this.compareNodeBasics(node, node2, differenceListener);
        boolean bl2 = false;
        if (bl) {
            switch (node.getNodeType()) {
                case 1: {
                    this.compareElement((Element)node, (Element)node2, differenceListener);
                    break;
                }
                case 4: {
                    this.compareCDataSection((CDATASection)node, (CDATASection)node2, differenceListener);
                    break;
                }
                case 8: {
                    this.compareComment((Comment)node, (Comment)node2, differenceListener);
                    break;
                }
                case 10: {
                    this.compareDocumentType((DocumentType)node, (DocumentType)node2, differenceListener);
                    break;
                }
                case 7: {
                    this.compareProcessingInstruction((ProcessingInstruction)node, (ProcessingInstruction)node2, differenceListener);
                    break;
                }
                case 3: {
                    this.compareText((Text)node, (Text)node2, differenceListener);
                    break;
                }
                case 9: {
                    bl2 = true;
                    this.compareDocument((Document)node, (Document)node2, differenceListener);
                    break;
                }
                default: {
                    differenceListener.skippedComparison(node, node2);
                }
            }
        }
        this.compareHasChildNodes(node, node2, differenceListener);
        if (bl2) {
            Element element = ((Document)node).getDocumentElement();
            Element element2 = ((Document)node2).getDocumentElement();
            if (element != null && element2 != null) {
                this.compareNode(element, element2, differenceListener);
            }
        } else {
            this.compareNodeChildren(node, node2, differenceListener);
        }
    }

    protected void compareDocument(Document document, Document document2, DifferenceListener differenceListener) throws DifferenceFoundException {
        DocumentType documentType = document.getDoctype();
        DocumentType documentType2 = document2.getDoctype();
        this.compare(this.getNullOrNotNull(documentType), this.getNullOrNotNull(documentType2), documentType, documentType2, differenceListener, DifferenceConstants.HAS_DOCTYPE_DECLARATION);
        if (documentType != null && documentType2 != null) {
            this.compareNode(documentType, documentType2, differenceListener);
        }
    }

    protected boolean compareNodeBasics(Node node, Node node2, DifferenceListener differenceListener) throws DifferenceFoundException {
        Short s = new Short(node.getNodeType());
        Short s2 = new Short(node2.getNodeType());
        this.compare(s, s2, node, node2, differenceListener, DifferenceConstants.NODE_TYPE);
        this.compare(node.getNamespaceURI(), node2.getNamespaceURI(), node, node2, differenceListener, DifferenceConstants.NAMESPACE_URI);
        this.compare(node.getPrefix(), node2.getPrefix(), node, node2, differenceListener, DifferenceConstants.NAMESPACE_PREFIX);
        return s.equals(s2);
    }

    protected void compareHasChildNodes(Node node, Node node2, DifferenceListener differenceListener) throws DifferenceFoundException {
        Boolean bl = node.hasChildNodes() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = node2.hasChildNodes() ? Boolean.TRUE : Boolean.FALSE;
        this.compare(bl, bl2, node, node2, differenceListener, DifferenceConstants.HAS_CHILD_NODES);
    }

    protected void compareNodeChildren(Node node, Node node2, DifferenceListener differenceListener) throws DifferenceFoundException {
        if (node.hasChildNodes() && node2.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            NodeList nodeList2 = node2.getChildNodes();
            Integer n = new Integer(nodeList.getLength());
            Integer n2 = new Integer(nodeList2.getLength());
            this.compare(n, n2, node, node2, differenceListener, DifferenceConstants.CHILD_NODELIST_LENGTH);
            this.compareNodeList(nodeList, nodeList2, n, differenceListener);
        }
    }

    protected void compareNodeList(NodeList nodeList, NodeList nodeList2, int n, DifferenceListener differenceListener) throws DifferenceFoundException {
        Node node = null;
        int n2 = 0;
        int n3 = nodeList2.getLength() - 1;
        String string = null;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            boolean bl;
            Node node2 = nodeList.item(n4);
            if (node2 instanceof Element) {
                bl = true;
                string = node2.getNodeName();
            } else {
                bl = false;
            }
            short s = node2.getNodeType();
            n2 = n5 = n4 > n3 ? n3 : n4;
            boolean bl2 = true;
            while (bl2) {
                if (bl && nodeList2.item(n2) instanceof Element && nodeList2.item(n2).getNodeName().equals(string)) {
                    bl2 = false;
                    continue;
                }
                if (!bl && s == nodeList2.item(n2).getNodeType()) {
                    bl2 = false;
                    continue;
                }
                if (++n2 > n3) {
                    n2 = 0;
                }
                if (n2 != n5) continue;
                bl2 = false;
            }
            node = nodeList2.item(n2);
            this.compare(new Integer(n4), new Integer(n2), node2, node, differenceListener, DifferenceConstants.CHILD_NODELIST_SEQUENCE);
            this.compareNode(node2, node, differenceListener);
            ++n4;
        }
    }

    private boolean isNamespaced(Node node) {
        String string = node.getNamespaceURI();
        return string != null && string.length() > 0;
    }

    protected void compareElement(Element element, Element element2, DifferenceListener differenceListener) throws DifferenceFoundException {
        if (this.isNamespaced(element)) {
            this.compare(element.getLocalName(), element2.getLocalName(), element, element2, differenceListener, DifferenceConstants.ELEMENT_TAG_NAME);
        } else {
            this.compare(element.getTagName(), element2.getTagName(), element, element2, differenceListener, DifferenceConstants.ELEMENT_TAG_NAME);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        NamedNodeMap namedNodeMap2 = element2.getAttributes();
        this.compare(new Integer(namedNodeMap.getLength()), new Integer(namedNodeMap2.getLength()), element, element2, differenceListener, DifferenceConstants.ELEMENT_NUM_ATTRIBUTES);
        this.compareElementAttributes(element, element2, namedNodeMap, namedNodeMap2, differenceListener);
    }

    private void compareElementAttributes(Element element, Element element2, NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2, DifferenceListener differenceListener) throws DifferenceFoundException {
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            Attr attr2 = null;
            String string = attr.getName();
            if (!this.isXMLNSAttribute(attr)) {
                if (namedNodeMap2.getNamedItem(string) != null) {
                    attr2 = (Attr)namedNodeMap2.getNamedItem(string);
                    this.compareAttribute(attr, attr2, differenceListener);
                    Attr attr3 = (Attr)namedNodeMap2.item(n);
                    String string2 = attr3 == null ? "[attribute absent]" : namedNodeMap2.item(n).getNodeName();
                    this.compare(string, string2, attr, attr2, differenceListener, DifferenceConstants.ATTR_SEQUENCE);
                } else {
                    this.compare(string, null, element, element2, differenceListener, DifferenceConstants.ATTR_NAME_NOT_FOUND);
                }
            }
            ++n;
        }
    }

    private boolean isXMLNSAttribute(Attr attr) {
        return "xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getName());
    }

    protected void compareAttribute(Attr attr, Attr attr2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compare(attr.getValue(), attr2.getValue(), attr, attr2, differenceListener, DifferenceConstants.ATTR_VALUE);
        this.compare(attr.getSpecified() ? Boolean.TRUE : Boolean.FALSE, attr2.getSpecified() ? Boolean.TRUE : Boolean.FALSE, attr, attr2, differenceListener, DifferenceConstants.ATTR_VALUE_EXPLICITLY_SPECIFIED);
    }

    protected void compareCDataSection(CDATASection cDATASection, CDATASection cDATASection2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compareCharacterData(cDATASection, cDATASection2, differenceListener, DifferenceConstants.CDATA_VALUE);
    }

    protected void compareComment(Comment comment, Comment comment2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compareCharacterData(comment, comment2, differenceListener, DifferenceConstants.COMMENT_VALUE);
    }

    protected void compareDocumentType(DocumentType documentType, DocumentType documentType2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compare(documentType.getName(), documentType2.getName(), documentType, documentType2, differenceListener, DifferenceConstants.DOCTYPE_NAME);
        this.compare(documentType.getPublicId(), documentType2.getPublicId(), documentType, documentType2, differenceListener, DifferenceConstants.DOCTYPE_PUBLIC_ID);
        this.compare(documentType.getSystemId(), documentType2.getSystemId(), documentType, documentType2, differenceListener, DifferenceConstants.DOCTYPE_SYSTEM_ID);
    }

    protected void compareProcessingInstruction(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compare(processingInstruction.getTarget(), processingInstruction2.getTarget(), processingInstruction, processingInstruction2, differenceListener, DifferenceConstants.PROCESSING_INSTRUCTION_TARGET);
        this.compare(processingInstruction.getData(), processingInstruction2.getData(), processingInstruction, processingInstruction2, differenceListener, DifferenceConstants.PROCESSING_INSTRUCTION_DATA);
    }

    protected void compareText(Text text, Text text2, DifferenceListener differenceListener) throws DifferenceFoundException {
        this.compareCharacterData(text, text2, differenceListener, DifferenceConstants.TEXT_VALUE);
    }

    private void compareCharacterData(CharacterData characterData, CharacterData characterData2, DifferenceListener differenceListener, Difference difference) throws DifferenceFoundException {
        this.compare(characterData.getData(), characterData2.getData(), characterData, characterData2, differenceListener, difference);
    }

    protected void compare(Object object, Object object2, Node node, Node node2, DifferenceListener differenceListener, Difference difference) throws DifferenceFoundException {
        if (this.unequal(object, object2)) {
            differenceListener.differenceFound(String.valueOf(object), String.valueOf(object2), node, node2, difference);
            if (differenceListener.haltComparison(difference)) {
                throw this.flowControlException;
            }
        }
    }

    private boolean unequal(Object object, Object object2) {
        return object == null ? object2 != null : this.unequalNotNull(object, object2);
    }

    private boolean unequalNotNull(Object object, Object object2) {
        if (XMLUnit.getIgnoreWhitespace() && object instanceof String && object2 instanceof String) {
            return !((String)object).trim().equals(((String)object2).trim());
        }
        return !object.equals(object2);
    }

    protected final class DifferenceFoundException
    extends Exception {
        private DifferenceFoundException() {
            super("This exception is used to control flow");
        }
    }
}

