/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.Transform;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class Diff
implements DifferenceListener,
DifferenceConstants {
    private final Document controlDoc;
    private final Document testDoc;
    private boolean similar = true;
    private boolean identical = true;
    private boolean compared = false;
    private boolean haltComparison = false;
    private StringBuffer messages;
    private DifferenceEngine differenceEngine;
    private DifferenceListener differenceListenerDelegate;

    public Diff(String string, String string2) throws SAXException, IOException, ParserConfigurationException {
        this(new StringReader(string), new StringReader(string2));
    }

    public Diff(Reader reader, Reader reader2) throws SAXException, IOException, ParserConfigurationException {
        this(XMLUnit.buildDocument(XMLUnit.getControlParser(), reader), XMLUnit.buildDocument(XMLUnit.getTestParser(), reader2));
    }

    public Diff(Document document, Document document2) {
        this(document, document2, new DifferenceEngine());
    }

    public Diff(String string, Transform transform) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this(XMLUnit.buildControlDocument(string), transform.getResultDocument());
    }

    public Diff(Document document, Document document2, DifferenceEngine differenceEngine) {
        this.controlDoc = this.getWhitespaceManipulatedDocument(document);
        this.testDoc = this.getWhitespaceManipulatedDocument(document2);
        this.differenceEngine = differenceEngine;
        this.messages = new StringBuffer();
    }

    protected Diff(Diff diff) {
        this.controlDoc = diff.controlDoc;
        this.testDoc = diff.testDoc;
        this.differenceEngine = diff.differenceEngine;
        this.messages = new StringBuffer();
    }

    private Document getWhitespaceManipulatedDocument(Document document) {
        if (!XMLUnit.getIgnoreWhitespace()) {
            return document;
        }
        try {
            Transform transform = XMLUnit.getStripWhitespaceTransform(document);
            return transform.getResultDocument();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            throw new RuntimeException(transformerException.getMessageAndLocation() + "\n" + transformerException.getCause());
        }
    }

    protected final void compare() {
        if (this.compared) {
            return;
        }
        this.differenceEngine.compare(this.controlDoc, this.testDoc, this);
        this.compared = true;
    }

    public boolean similar() {
        this.compare();
        return this.similar;
    }

    public boolean identical() {
        this.compare();
        return this.identical;
    }

    private void appendComparingWhat(StringBuffer stringBuffer, Node node, Node node2) {
        stringBuffer.append(" - comparing ");
        this.appendNodeDetail(stringBuffer, node, true);
        stringBuffer.append(" to ");
        this.appendNodeDetail(stringBuffer, node2, true);
    }

    private void appendNodeDetail(StringBuffer stringBuffer, Node node, boolean bl) {
        if (node == null) {
            return;
        }
        if (bl) {
            stringBuffer.append("<");
        }
        switch (node.getNodeType()) {
            case 2: {
                this.appendNodeDetail(stringBuffer, ((Attr)node).getOwnerElement(), false);
                stringBuffer.append(' ').append(node.getNodeName()).append("=\"").append(node.getNodeValue()).append("\"...");
                break;
            }
            case 1: {
                stringBuffer.append(node.getNodeName());
                if (!bl) break;
                stringBuffer.append("...");
                break;
            }
            case 3: {
                this.appendNodeDetail(stringBuffer, node.getParentNode(), false);
                stringBuffer.append(" ...").append(">").append(node.getNodeValue()).append("</");
                this.appendNodeDetail(stringBuffer, node.getParentNode(), false);
                break;
            }
            case 4: {
                stringBuffer.append("![CDATA[").append(node.getNodeValue()).append("]]");
                break;
            }
            case 8: {
                stringBuffer.append("!--").append(node.getNodeValue()).append("--");
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                stringBuffer.append("?").append(processingInstruction.getTarget()).append(' ').append(processingInstruction.getData()).append("]]");
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                stringBuffer.append("!DOCTYPE ").append(documentType.getName());
                if (documentType.getPublicId() != null && documentType.getPublicId().length() > 0) {
                    stringBuffer.append(" PUBLIC \"").append(documentType.getPublicId()).append('\"');
                }
                if (documentType.getSystemId() == null || documentType.getSystemId().length() <= 0) break;
                stringBuffer.append(" SYSTEM \"").append(documentType.getSystemId()).append('\"');
                break;
            }
            case 9: {
                stringBuffer.append("Document Node ").append("<").append("...").append(">");
                break;
            }
            default: {
                stringBuffer.append("!--NodeType ").append(node.getNodeType()).append(' ').append(node.getNodeName()).append('/').append(node.getNodeValue()).append("--");
            }
        }
        if (bl) {
            stringBuffer.append(">");
        }
    }

    private void appendDifference(StringBuffer stringBuffer, String string, String string2, Node node, Node node2, Difference difference) {
        stringBuffer.append(" Expected ").append(difference.getDescription()).append(" '").append(string).append("' but was '").append(string2).append("'");
        this.appendComparingWhat(stringBuffer, node, node2);
        stringBuffer.append('\n');
    }

    public int differenceFound(String string, String string2, Node node, Node node2, Difference difference) {
        int n = 0;
        if (this.differenceListenerDelegate != null) {
            n = this.differenceListenerDelegate.differenceFound(string, string2, node, node2, difference);
        }
        switch (n) {
            case 1: {
                return n;
            }
            case 2: {
                this.identical = false;
                this.haltComparison = false;
                break;
            }
            case 0: {
                this.identical = false;
                if (difference.isRecoverable()) {
                    this.haltComparison = false;
                    break;
                }
                this.similar = false;
                this.haltComparison = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a defined DifferenceListener.RETURN_... value");
            }
        }
        if (this.haltComparison) {
            this.messages.append("\n[different]");
        } else {
            this.messages.append("\n[not identical]");
        }
        this.appendDifference(this.messages, string, string2, node, node2, difference);
        return n;
    }

    public void skippedComparison(Node node, Node node2) {
        if (this.differenceListenerDelegate != null) {
            this.differenceListenerDelegate.skippedComparison(node, node2);
        } else {
            System.err.println("DifferenceListener.skippedComparison: unhandled control node type=" + node + ", unhandled test node type=" + node2);
        }
    }

    public boolean haltComparison(Difference difference) {
        if (this.differenceListenerDelegate != null) {
            return this.differenceListenerDelegate.haltComparison(difference);
        }
        return this.haltComparison;
    }

    public StringBuffer appendMessage(StringBuffer stringBuffer) {
        this.compare();
        if (this.messages.length() == 0) {
            this.messages.append("[identical]");
        }
        return stringBuffer.append(this.messages.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.appendMessage(stringBuffer);
        return stringBuffer.toString();
    }

    public void overrideDifferenceListener(DifferenceListener differenceListener) {
        this.differenceListenerDelegate = differenceListener;
    }
}

