/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.w3c.dom.Node;

public class CountingNodeTester
implements NodeTester {
    private final int expectedNumNodes;
    private int actualNumNodes;

    public CountingNodeTester(int n) {
        this.expectedNumNodes = n;
    }

    public void testNode(Node node, NodeTest nodeTest) {
        ++this.actualNumNodes;
    }

    public void noMoreNodes(NodeTest nodeTest) throws NodeTestException {
        int n = this.actualNumNodes;
        this.resetCounter();
        if (n != this.expectedNumNodes) {
            throw new NodeTestException("Counted " + n + " node(s) but expected " + this.expectedNumNodes);
        }
    }

    public void resetCounter() {
        this.actualNumNodes = 0;
    }
}

