/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.lang.reflect.Method;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUpdater
implements Updater {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$expression$MethodUpdater == null ? (class$org$apache$commons$betwixt$expression$MethodUpdater = MethodUpdater.class$("org.apache.commons.betwixt.expression.MethodUpdater")) : class$org$apache$commons$betwixt$expression$MethodUpdater));
    private Method method;
    private Class valueType;
    static /* synthetic */ Class class$org$apache$commons$betwixt$expression$MethodUpdater;

    public static void setLog(Log aLog) {
        log = aLog;
    }

    public MethodUpdater() {
    }

    public MethodUpdater(Method method) {
        this.setMethod(method);
    }

    public void update(Context context, Object newValue) {
        Object bean = context.getBean();
        if (bean != null) {
            if (newValue instanceof String) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Converting primitive to " + this.valueType));
                }
                newValue = context.getObjectStringConverter().stringToObject((String)newValue, this.valueType, null, context);
            }
            if (newValue != null) {
                // empty if block
            }
            Object[] arguments = new Object[]{newValue};
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling setter method: " + this.method.getName() + " on bean: " + bean + " with new value: " + newValue));
                }
                this.method.invoke(bean, arguments);
            }
            catch (Exception e) {
                String valueTypeName = newValue != null ? newValue.getClass().getName() : "null";
                log.warn((Object)("Cannot evaluate method: " + this.method.getName() + " on bean: " + bean + " of type: " + bean.getClass().getName() + " with value: " + newValue + " of type: " + valueTypeName));
                this.handleException(context, e);
            }
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        Class<?>[] types = method.getParameterTypes();
        if (types == null || types.length <= 0) {
            throw new IllegalArgumentException("The Method must have at least one parameter");
        }
        this.valueType = types[0];
    }

    protected void handleException(Context context, Exception e) {
        log.info((Object)("Caught exception: " + e), (Throwable)e);
    }

    public String toString() {
        return "MethodUpdater [method=" + this.method + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

