/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.common;

import java.io.DataInputStream;
import java.io.IOException;

public class ReqRepBytes {
    int m_byteSize;
    byte[] m_bytes;
    Boolean m_isRequest;
    IOException m_ioe;

    public ReqRepBytes(int byteSize, byte[] bytes, Boolean isRequest, IOException ioe) {
        this.m_byteSize = byteSize;
        this.m_bytes = bytes;
        this.m_isRequest = isRequest;
        this.m_ioe = ioe;
    }

    public boolean ioeDuringReadInt() {
        return this.m_ioe != null & this.m_byteSize == 0;
    }

    public boolean hadIOE() {
        return this.m_ioe != null;
    }

    public int getByteSize() {
        return this.m_byteSize;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public boolean isRequest() {
        return this.m_isRequest;
    }

    public IOException getIOException() {
        return this.m_ioe;
    }

    public static ReqRepBytes getRequestReplyBytesFromDataStream(DataInputStream dis) {
        int byteArraySize = 0;
        Boolean isRequest = null;
        byte[] byteArray = null;
        IOException ioe = null;
        try {
            byteArraySize = dis.readInt();
            isRequest = dis.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            byteArray = new byte[byteArraySize];
            dis.read(byteArray);
        }
        catch (IOException e) {
            ioe = e;
        }
        return new ReqRepBytes(byteArraySize, byteArray, isRequest, ioe);
    }
}

