/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

public class CellReference {
    private int row;
    private int col;
    private boolean rowAbs;
    private boolean colAbs;

    public CellReference(String cellRef) {
        String[] parts = this.seperateRowColumns(cellRef);
        String ref = parts[0];
        if (ref.charAt(0) == '$') {
            this.colAbs = true;
            ref = ref.substring(1);
        }
        this.col = this.convertColStringToNum(ref);
        ref = parts[1];
        if (ref.charAt(0) == '$') {
            this.rowAbs = true;
            ref = ref.substring(1);
        }
        this.row = Integer.parseInt(ref) - 1;
    }

    public CellReference(int pRow, int pCol) {
        this(pRow, pCol, false, false);
    }

    public CellReference(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        this.row = pRow;
        this.col = pCol;
        this.rowAbs = pAbsRow;
        this.colAbs = pAbsCol;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public boolean isRowAbsolute() {
        return this.rowAbs;
    }

    public boolean isColAbsolute() {
        return this.colAbs;
    }

    private int convertColStringToNum(String ref) {
        int len = ref.length();
        int retval = 0;
        int pos = 0;
        int k = ref.length() - 1;
        while (k > -1) {
            char thechar = ref.charAt(k);
            retval = pos == 0 ? (retval += Character.getNumericValue(thechar) - 9) : (retval += (Character.getNumericValue(thechar) - 9) * (pos * 26));
            ++pos;
            --k;
        }
        return retval - 1;
    }

    private String[] seperateRowColumns(String reference) {
        int loc;
        int start = reference.indexOf("!") + 1;
        String[] retval = new String[2];
        int length = reference.length();
        char[] chars = reference.toCharArray();
        if (chars[loc = start] == '$') {
            ++loc;
        }
        while (loc < chars.length) {
            if (Character.isDigit(chars[loc]) || chars[loc] == '$') break;
            ++loc;
        }
        retval[0] = reference.substring(start, loc);
        retval[1] = reference.substring(loc);
        return retval;
    }

    private static String convertNumToColString(int col) {
        String retval = null;
        int mod = col % 26;
        int div = col / 26;
        char small = (char)(mod + 65);
        char big = (char)(div + 64);
        retval = div == 0 ? "" + small : "" + big + "" + small;
        return retval;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.colAbs ? "$" : "");
        retval.append(CellReference.convertNumToColString(this.col));
        retval.append(this.rowAbs ? "$" : "");
        retval.append(this.row + 1);
        return retval.toString();
    }
}

