/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.util.CellReference;

public class AreaReference {
    private CellReference[] cells;
    private int dim;

    public AreaReference(String reference) {
        String[] refs = this.seperateAreaRefs(reference);
        this.dim = refs.length;
        this.cells = new CellReference[this.dim];
        int i = 0;
        while (i < this.dim) {
            this.cells[i] = new CellReference(refs[i]);
            ++i;
        }
    }

    public int getDim() {
        return this.dim;
    }

    public CellReference[] getCells() {
        return this.cells;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < this.dim) {
            retval.append(':');
            retval.append(this.cells[i].toString());
            ++i;
        }
        retval.deleteCharAt(0);
        return retval.toString();
    }

    private String[] seperateAreaRefs(String reference) {
        String[] retval = new String[2];
        int length = reference.length();
        int loc = reference.indexOf(58, 0);
        retval[0] = reference.substring(0, loc);
        retval[1] = reference.substring(loc + 1);
        return retval;
    }
}

