/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.hssf.util.SheetReferences;

public class HSSFName {
    private Workbook book;
    private NameRecord name;

    protected HSSFName(Workbook book, NameRecord name) {
        this.book = book;
        this.name = name;
    }

    public String getSheetName() {
        short indexToExternSheet = this.name.getExternSheetNumber();
        String result = this.book.findSheetNameFromExternSheet(indexToExternSheet);
        return result;
    }

    public String getNameName() {
        String result = this.name.getNameText();
        return result;
    }

    public void setNameName(String nameName) {
        this.name.setNameText(nameName);
        this.name.setNameTextLength((byte)nameName.length());
    }

    public String getReference() {
        SheetReferences refs = this.book.getSheetReferences();
        String result = this.name.getAreaReference(refs);
        return result;
    }

    private void setSheetName(String sheetName) {
        int sheetNumber = this.book.getSheetIndex(sheetName);
        short externSheetNumber = this.book.checkExternSheet(sheetNumber);
        this.name.setExternSheetNumber(externSheetNumber);
    }

    public void setReference(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String sheetName = ra.getSheetName();
        if (ra.hasSheetName()) {
            this.setSheetName(sheetName);
        }
        if (!ra.getFromCell().equals(ra.getToCell())) {
            this.name.setAreaReference(ra.getFromCell() + ":" + ra.getToCell());
        } else {
            this.name.setAreaReference(ra.getFromCell());
        }
    }
}

