/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.SheetReferences;

public class StringPtg
extends Ptg {
    public static final int SIZE = 9;
    public static final byte sid = 23;
    private String field_1_value;

    private StringPtg() {
    }

    public StringPtg(byte[] data, int offset) {
        this.setValue(new String(data, offset + 3, data[offset + 1] + 256 * data[offset + 2]));
    }

    public StringPtg(String value) {
        this.setValue(value);
    }

    public void setValue(String value) {
        this.field_1_value = value;
    }

    public String getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 23;
        array[offset + 1] = (byte)(this.getValue().length() % 256);
        array[offset + 2] = (byte)(this.getValue().length() / 256);
        System.arraycopy(this.getValue().getBytes(), 0, array, offset + 3, this.getValue().length());
    }

    public int getSize() {
        return this.field_1_value.length() + 3;
    }

    public String toFormulaString(SheetReferences refs) {
        return "\"" + this.getValue() + "\"";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        StringPtg ptg = new StringPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

