/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.LittleEndian;

public class NumberPtg
extends Ptg {
    public static final int SIZE = 9;
    public static final byte sid = 31;
    private double field_1_value;

    private NumberPtg() {
    }

    public NumberPtg(byte[] data, int offset) {
        this.setValue(LittleEndian.getDouble(data, offset + 1));
    }

    public NumberPtg(String value) {
        this.setValue(Double.parseDouble(value));
    }

    public void setValue(double value) {
        this.field_1_value = value;
    }

    public double getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 31;
        LittleEndian.putDouble(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 9;
    }

    public String toFormulaString(SheetReferences refs) {
        return "" + this.getValue();
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        NumberPtg ptg = new NumberPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

