/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class AttrPtg
extends OperationPtg {
    public static final byte sid = 25;
    private static final int SIZE = 4;
    private byte field_1_options;
    private short field_2_data;
    private BitField semiVolatile = new BitField(1);
    private BitField optiIf = new BitField(2);
    private BitField optiChoose = new BitField(4);
    private BitField optGoto = new BitField(8);
    private BitField sum = new BitField(16);
    private BitField baxcel = new BitField(32);
    private BitField space = new BitField(64);

    public AttrPtg() {
    }

    public AttrPtg(byte[] data, int offset) {
        this.field_1_options = data[++offset + 0];
        this.field_2_data = LittleEndian.getShort(data, offset + 1);
    }

    public void setOptions(byte options) {
        this.field_1_options = options;
    }

    public byte getOptions() {
        return this.field_1_options;
    }

    public boolean isSemiVolatile() {
        return this.semiVolatile.isSet(this.getOptions());
    }

    public boolean isOptimizedIf() {
        return this.optiIf.isSet(this.getOptions());
    }

    public boolean isOptimizedChoose() {
        return this.optiChoose.isSet(this.getOptions());
    }

    public boolean isGoto() {
        return this.optGoto.isSet(this.getOptions());
    }

    public boolean isSum() {
        return this.sum.isSet(this.getOptions());
    }

    public void setSum(boolean bsum) {
        this.field_1_options = this.sum.setByteBoolean(this.field_1_options, bsum);
    }

    public void setOptimizedIf(boolean bif) {
        this.field_1_options = this.optiIf.setByteBoolean(this.field_1_options, bif);
    }

    public boolean isBaxcel() {
        return this.baxcel.isSet(this.getOptions());
    }

    public boolean isSpace() {
        return this.space.isSet(this.getOptions());
    }

    public void setData(short data) {
        this.field_2_data = data;
    }

    public short getData() {
        return this.field_2_data;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AttrPtg\n");
        buffer.append("options=").append(this.field_1_options).append("\n");
        buffer.append("data   =").append(this.field_2_data).append("\n");
        buffer.append("semi   =").append(this.isSemiVolatile()).append("\n");
        buffer.append("optimif=").append(this.isOptimizedIf()).append("\n");
        buffer.append("optchos=").append(this.isOptimizedChoose()).append("\n");
        buffer.append("isGoto =").append(this.isGoto()).append("\n");
        buffer.append("isSum  =").append(this.isSum()).append("\n");
        buffer.append("isBaxce=").append(this.isBaxcel()).append("\n");
        buffer.append("isSpace=").append(this.isSpace()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = 25;
        array[offset + 1] = this.field_1_options;
        LittleEndian.putShort(array, offset + 2, this.field_2_data);
    }

    public int getSize() {
        return 4;
    }

    public String toFormulaString(String[] operands) {
        if (this.space.isSet(this.field_1_options)) {
            return operands[0];
        }
        if (this.optiIf.isSet(this.field_1_options)) {
            return this.toFormulaString((SheetReferences)null) + "(" + operands[0] + ")";
        }
        if (this.optGoto.isSet(this.field_1_options)) {
            return this.toFormulaString((SheetReferences)null) + operands[0];
        }
        return this.toFormulaString((SheetReferences)null) + "(" + operands[0] + ")";
    }

    public int getNumberOfOperands() {
        return 1;
    }

    public int getType() {
        return -1;
    }

    public String toFormulaString(SheetReferences refs) {
        if (this.semiVolatile.isSet(this.field_1_options)) {
            return "ATTR(semiVolatile)";
        }
        if (this.optiIf.isSet(this.field_1_options)) {
            return "IF";
        }
        if (this.optiChoose.isSet(this.field_1_options)) {
            return "CHOOSE";
        }
        if (this.optGoto.isSet(this.field_1_options)) {
            return "";
        }
        if (this.sum.isSet(this.field_1_options)) {
            return "SUM";
        }
        if (this.baxcel.isSet(this.field_1_options)) {
            return "ATTR(baxcel)";
        }
        if (this.space.isSet(this.field_1_options)) {
            return "";
        }
        return "UNKNOWN ATTRIBUTE";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        AttrPtg ptg = new AttrPtg();
        ptg.field_1_options = this.field_1_options;
        ptg.field_2_data = this.field_2_data;
        return ptg;
    }
}

