/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class StringRecord
extends Record {
    public static final short sid = 519;
    private int field_1_string_length;
    private byte field_2_unicode_flag;
    private String field_3_string;

    public StringRecord() {
    }

    public StringRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public StringRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 519) {
            throw new RecordFormatException("Not a valid StringRecord");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_string_length = LittleEndian.getUShort(data, 0 + offset);
        this.field_2_unicode_flag = data[2 + offset];
        this.field_3_string = this.isUnCompressedUnicode() ? StringUtil.getFromUnicode(data, 3 + offset, this.field_1_string_length) : new String(data, 3 + offset, this.field_1_string_length);
    }

    private int getStringLength() {
        return this.field_1_string_length;
    }

    private int getStringByteLength() {
        return this.isUnCompressedUnicode() ? this.field_1_string_length * 2 : this.field_1_string_length;
    }

    public int getRecordSize() {
        return 7 + this.getStringByteLength();
    }

    public boolean isUnCompressedUnicode() {
        return this.field_2_unicode_flag == 1;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)519);
        LittleEndian.putShort(data, 2 + offset, (short)(3 + this.getStringByteLength()));
        LittleEndian.putUShort(data, 4 + offset, this.field_1_string_length);
        data[6 + offset] = this.field_2_unicode_flag;
        if (this.isUnCompressedUnicode()) {
            StringUtil.putUncompressedUnicode(this.field_3_string, data, 7 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.field_3_string, data, 7 + offset);
        }
        return this.getRecordSize();
    }

    public short getSid() {
        return 519;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setCompressedFlag(byte unicode_flag) {
        this.field_2_unicode_flag = unicode_flag;
    }

    public void setString(String string) {
        this.field_1_string_length = string.length();
        this.field_3_string = string;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STRING]\n");
        buffer.append("    .string            = ").append(this.field_3_string).append("\n");
        buffer.append("[/STRING]\n");
        return buffer.toString();
    }
}

