/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.RecordProcessor;
import org.apache.poi.hssf.record.SSTRecordHeader;
import org.apache.poi.hssf.record.SSTRecordSizeCalculator;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.BinaryTree;

class SSTSerializer {
    private List recordLengths;
    private BinaryTree strings;
    private int numStrings;
    private int numUniqueStrings;
    private SSTRecordHeader sstRecordHeader;

    public SSTSerializer(List recordLengths, BinaryTree strings, int numStrings, int numUniqueStrings) {
        this.recordLengths = recordLengths;
        this.strings = strings;
        this.numStrings = numStrings;
        this.numUniqueStrings = numUniqueStrings;
        this.sstRecordHeader = new SSTRecordHeader(numStrings, numUniqueStrings);
    }

    public int serialize(int record_size, int offset, byte[] data) {
        int record_length_index = 0;
        if (this.calculateUnicodeSize() > 8216) {
            this.serializeLargeRecord(record_size, record_length_index, data, offset);
        } else {
            this.serializeSingleSSTRecord(data, offset, record_length_index);
        }
        return record_size;
    }

    public static int calculateUnicodeSize(Map strings) {
        int retval = 0;
        int k = 0;
        while (k < strings.size()) {
            retval += SSTSerializer.getUnicodeString(strings, k).getRecordSize();
            ++k;
        }
        return retval;
    }

    public int calculateUnicodeSize() {
        return SSTSerializer.calculateUnicodeSize(this.strings);
    }

    private void serializeSingleSSTRecord(byte[] data, int offset, int record_length_index) {
        int len = (Integer)this.recordLengths.get(record_length_index);
        int recordSize = 12 + len - 4;
        this.sstRecordHeader.writeSSTHeader(data, 0 + offset, recordSize);
        int pos = 12;
        int k = 0;
        while (k < this.strings.size()) {
            System.arraycopy(this.getUnicodeString(k).serialize(), 0, data, pos + offset, this.getUnicodeString(k).getRecordSize());
            pos += this.getUnicodeString(k).getRecordSize();
            ++k;
        }
    }

    private void serializeLargeRecord(int record_size, int record_length_index, byte[] buffer, int offset) {
        byte[] stringReminant = null;
        int stringIndex = 0;
        boolean lastneedcontinue = false;
        boolean first_record = true;
        int totalWritten = 0;
        while (totalWritten != record_size) {
            int recordLength = (Integer)this.recordLengths.get(record_length_index++);
            RecordProcessor recordProcessor = new RecordProcessor(buffer, recordLength, this.numStrings, this.numUniqueStrings);
            recordProcessor.writeRecordHeader(offset, totalWritten, recordLength, first_record);
            first_record = false;
            if (lastneedcontinue) {
                lastneedcontinue = stringReminant.length > recordProcessor.getAvailable();
                stringReminant = recordProcessor.writeStringRemainder(lastneedcontinue, stringReminant, offset, totalWritten);
            }
            while (stringIndex < this.strings.size()) {
                UnicodeString unistr = this.getUnicodeString(stringIndex);
                if (unistr.getRecordSize() > recordProcessor.getAvailable()) {
                    if (recordProcessor.getAvailable() < 3) break;
                    stringReminant = recordProcessor.writePartString(unistr, offset, totalWritten);
                    lastneedcontinue = true;
                    ++stringIndex;
                    break;
                }
                recordProcessor.writeWholeString(unistr, offset, totalWritten);
                ++stringIndex;
            }
            totalWritten += recordLength + 4;
        }
    }

    private UnicodeString getUnicodeString(int index) {
        return SSTSerializer.getUnicodeString(this.strings, index);
    }

    private static UnicodeString getUnicodeString(Map strings, int index) {
        Integer intunipos = new Integer(index);
        return (UnicodeString)strings.get(intunipos);
    }

    public int getRecordSize() {
        SSTRecordSizeCalculator calculator = new SSTRecordSizeCalculator(this.strings);
        int recordSize = calculator.getRecordSize();
        this.recordLengths = calculator.getRecordLengths();
        return recordSize;
    }

    public List getRecordLengths() {
        return this.recordLengths;
    }
}

