/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

public abstract class Record {
    public short sid = 0;
    private short id = 0;
    private short size = 0;
    private byte[] data = null;

    public Record() {
    }

    public Record(short id, short size, byte[] data) {
        this.id = id;
        this.size = size;
        this.data = data;
        this.validateSid(id);
        this.fillFields(data, size);
    }

    public Record(short id, short size, byte[] data, int offset) {
        this.id = id;
        this.size = size;
        this.data = data;
        this.validateSid(id);
        this.fillFields(data, size, offset);
    }

    protected abstract void validateSid(short var1);

    protected void fillFields(byte[] data, short size) {
        this.fillFields(data, size, 0);
    }

    protected abstract void fillFields(byte[] var1, short var2, int var3);

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public abstract int serialize(int var1, byte[] var2);

    public int getRecordSize() {
        return this.serialize().length;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isInValueSection() {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public void processContinueRecord(byte[] record) {
    }

    public abstract short getSid();

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }
}

