/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ProtectRecord
extends Record {
    public static final short sid = 18;
    private short field_1_protect;

    public ProtectRecord() {
    }

    public ProtectRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public ProtectRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 18) {
            throw new RecordFormatException("NOT A PROTECT RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_protect = LittleEndian.getShort(data, 0 + offset);
    }

    public void setProtect(boolean protect) {
        this.field_1_protect = protect ? (short)1 : 0;
    }

    public short getProtect() {
        return this.field_1_protect;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PROTECT]\n");
        buffer.append("    .protected      = ").append(Integer.toHexString(this.getProtect())).append("\n");
        buffer.append("[/PROTECT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)18);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getProtect());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 18;
    }
}

