/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class NameRecord
extends Record {
    public static final short sid = 24;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private byte field_3_length_name_text;
    private short field_4_length_name_definition;
    private short field_5_index_to_sheet;
    private short field_6_equals_to_index_to_sheet;
    private byte field_7_length_custom_menu;
    private byte field_8_length_description_text;
    private byte field_9_length_help_topic_text;
    private byte field_10_length_status_bar_text;
    private byte field_11_compressed_unicode_flag;
    private byte field_12_builtIn_name;
    private String field_12_name_text;
    private Stack field_13_name_definition;
    private byte[] field_13_raw_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Area3DPtg;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$formula$Ref3DPtg;

    public NameRecord() {
        this.field_13_name_definition = new Stack();
        this.field_12_name_text = new String();
        this.field_14_custom_menu_text = new String();
        this.field_15_description_text = new String();
        this.field_16_help_topic_text = new String();
        this.field_17_status_bar_text = new String();
    }

    public NameRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public NameRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public void setOptionFlag(short flag) {
        this.field_1_option_flag = flag;
    }

    public void setKeyboardShortcut(byte shortcut) {
        this.field_2_keyboard_shortcut = shortcut;
    }

    public void setNameTextLength(byte length) {
        this.field_3_length_name_text = length;
    }

    public void setDefinitionTextLength(short length) {
        this.field_4_length_name_definition = length;
    }

    public void setUnused(short index) {
        this.field_5_index_to_sheet = index;
    }

    public short getEqualsToIndexToSheet() {
        return this.field_6_equals_to_index_to_sheet;
    }

    public void setEqualsToIndexToSheet(short value) {
        this.field_6_equals_to_index_to_sheet = value;
    }

    public void setCustomMenuLength(byte length) {
        this.field_7_length_custom_menu = length;
    }

    public void setDescriptionTextLength(byte length) {
        this.field_8_length_description_text = length;
    }

    public void setHelpTopicLength(byte length) {
        this.field_9_length_help_topic_text = length;
    }

    public void setStatusBarLength(byte length) {
        this.field_10_length_status_bar_text = length;
    }

    public void setCompressedUnicodeFlag(byte flag) {
        this.field_11_compressed_unicode_flag = flag;
    }

    public void setNameText(String name) {
        this.field_12_name_text = name;
    }

    public void setCustomMenuText(String text) {
        this.field_14_custom_menu_text = text;
    }

    public void setDescriptionText(String text) {
        this.field_15_description_text = text;
    }

    public void setHelpTopicText(String text) {
        this.field_16_help_topic_text = text;
    }

    public void setStatusBarText(String text) {
        this.field_17_status_bar_text = text;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    public byte getNameTextLength() {
        return this.field_3_length_name_text;
    }

    public short getDefinitionTextLength() {
        return this.field_4_length_name_definition;
    }

    public short getUnused() {
        return this.field_5_index_to_sheet;
    }

    public byte getCustomMenuLength() {
        return this.field_7_length_custom_menu;
    }

    public byte getDescriptionTextLength() {
        return this.field_8_length_description_text;
    }

    public byte getHelpTopicLength() {
        return this.field_9_length_help_topic_text;
    }

    public byte getStatusBarLength() {
        return this.field_10_length_status_bar_text;
    }

    public byte getCompressedUnicodeFlag() {
        return this.field_11_compressed_unicode_flag;
    }

    public String getNameText() {
        return this.field_12_name_text;
    }

    public List getNameDefinition() {
        return this.field_13_name_definition;
    }

    public void setNameDefinition(Stack nameDefinition) {
        this.field_13_name_definition = nameDefinition;
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    protected void validateSid(short id) {
        if (id != 24) {
            throw new RecordFormatException("NOT A valid Name RECORD");
        }
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)24);
        LittleEndian.putShort(data, 4 + offset, this.getOptionFlag());
        data[6 + offset] = this.getKeyboardShortcut();
        data[7 + offset] = this.getNameTextLength();
        LittleEndian.putShort(data, 8 + offset, this.getDefinitionTextLength());
        LittleEndian.putShort(data, 10 + offset, this.getUnused());
        LittleEndian.putShort(data, 12 + offset, this.getEqualsToIndexToSheet());
        data[14 + offset] = this.getCustomMenuLength();
        data[15 + offset] = this.getDescriptionTextLength();
        data[16 + offset] = this.getHelpTopicLength();
        data[17 + offset] = this.getStatusBarLength();
        data[18 + offset] = this.getCompressedUnicodeFlag();
        LittleEndian.putShort(data, 2 + offset, (short)(15 + this.getTextsLength()));
        StringUtil.putCompressedUnicode(this.getNameText(), data, 19 + offset);
        int start_of_name_definition = 19 + this.field_3_length_name_text;
        if (this.field_13_name_definition != null) {
            this.serializePtgs(data, start_of_name_definition + offset);
        } else {
            System.arraycopy(this.field_13_raw_name_definition, 0, data, start_of_name_definition + offset, this.field_13_raw_name_definition.length);
        }
        int start_of_custom_menu_text = start_of_name_definition + this.field_4_length_name_definition;
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), data, start_of_custom_menu_text + offset);
        int start_of_description_text = start_of_custom_menu_text + this.field_8_length_description_text;
        StringUtil.putCompressedUnicode(this.getDescriptionText(), data, start_of_description_text + offset);
        int start_of_help_topic_text = start_of_description_text + this.field_9_length_help_topic_text;
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), data, start_of_help_topic_text + offset);
        int start_of_status_bar_text = start_of_help_topic_text + this.field_10_length_status_bar_text;
        StringUtil.putCompressedUnicode(this.getStatusBarText(), data, start_of_status_bar_text + offset);
        return this.getRecordSize();
    }

    private void serializePtgs(byte[] data, int offset) {
        int pos = offset;
        int k = 0;
        while (k < this.field_13_name_definition.size()) {
            Ptg ptg = (Ptg)this.field_13_name_definition.get(k);
            ptg.writeBytes(data, pos);
            pos += ptg.getSize();
            ++k;
        }
    }

    public int getTextsLength() {
        int result = this.getNameTextLength() + this.getDefinitionTextLength() + this.getDescriptionTextLength() + this.getHelpTopicLength() + this.getStatusBarLength();
        return result;
    }

    public int getRecordSize() {
        int result = 19 + this.getTextsLength();
        return result;
    }

    public short getExternSheetNumber() {
        if (this.field_13_name_definition == null) {
            return 0;
        }
        Ptg ptg = (Ptg)this.field_13_name_definition.peek();
        short result = 0;
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            result = ((Area3DPtg)ptg).getExternSheetIndex();
        } else if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            result = ((Ref3DPtg)ptg).getExternSheetIndex();
        }
        return result;
    }

    public void setExternSheetNumber(short externSheetNumber) {
        Ptg ptg;
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            ptg = this.createNewPtg();
        } else {
            ptg = (Ptg)this.field_13_name_definition.peek();
        }
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            ((Area3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        } else if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            ((Ref3DPtg)ptg).setExternSheetIndex(externSheetNumber);
        }
    }

    private Ptg createNewPtg() {
        Area3DPtg ptg = new Area3DPtg();
        this.field_13_name_definition.push(ptg);
        return ptg;
    }

    public String getAreaReference(SheetReferences refs) {
        if (this.field_13_name_definition == null) {
            return "#REF!";
        }
        Ptg ptg = (Ptg)this.field_13_name_definition.peek();
        String result = "";
        if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            result = ptg.toFormulaString(refs);
        } else if (ptg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            result = ptg.toFormulaString(refs);
        }
        return result;
    }

    public void setAreaReference(String ref) {
        Ptg ptg;
        Ptg oldPtg;
        RangeAddress ra = new RangeAddress(ref);
        if (this.field_13_name_definition == null || this.field_13_name_definition.isEmpty()) {
            this.field_13_name_definition = new Stack();
            oldPtg = this.createNewPtg();
        } else {
            oldPtg = (Ptg)this.field_13_name_definition.pop();
        }
        short externSheetIndex = 0;
        if (oldPtg.getClass() == (class$org$apache$poi$hssf$record$formula$Area3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Area3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Area3DPtg")) : class$org$apache$poi$hssf$record$formula$Area3DPtg)) {
            externSheetIndex = ((Area3DPtg)oldPtg).getExternSheetIndex();
        } else if (oldPtg.getClass() == (class$org$apache$poi$hssf$record$formula$Ref3DPtg == null ? (class$org$apache$poi$hssf$record$formula$Ref3DPtg = NameRecord.class$("org.apache.poi.hssf.record.formula.Ref3DPtg")) : class$org$apache$poi$hssf$record$formula$Ref3DPtg)) {
            externSheetIndex = ((Ref3DPtg)oldPtg).getExternSheetIndex();
        }
        if (ra.hasRange()) {
            ptg = new Area3DPtg();
            ((Area3DPtg)ptg).setExternSheetIndex(externSheetIndex);
            ((Area3DPtg)ptg).setArea(ref);
            this.setDefinitionTextLength((short)ptg.getSize());
        } else {
            ptg = new Ref3DPtg();
            ((Ref3DPtg)ptg).setExternSheetIndex(externSheetIndex);
            ((Ref3DPtg)ptg).setArea(ref);
            this.setDefinitionTextLength((short)ptg.getSize());
        }
        this.field_13_name_definition.push(ptg);
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_option_flag = LittleEndian.getShort(data, 0 + offset);
        this.field_2_keyboard_shortcut = data[2 + offset];
        this.field_3_length_name_text = data[3 + offset];
        this.field_4_length_name_definition = LittleEndian.getShort(data, 4 + offset);
        this.field_5_index_to_sheet = LittleEndian.getShort(data, 6 + offset);
        this.field_6_equals_to_index_to_sheet = LittleEndian.getShort(data, 8 + offset);
        this.field_7_length_custom_menu = data[10 + offset];
        this.field_8_length_description_text = data[11 + offset];
        this.field_9_length_help_topic_text = data[12 + offset];
        this.field_10_length_status_bar_text = data[13 + offset];
        this.field_11_compressed_unicode_flag = data[14 + offset];
        this.field_12_name_text = new String(data, 15 + offset, LittleEndian.ubyteToInt(this.field_3_length_name_text));
        int start_of_name_definition = 15 + this.field_3_length_name_text;
        this.field_13_name_definition = this.getParsedExpressionTokens(data, this.field_4_length_name_definition, offset, start_of_name_definition);
        int start_of_custom_menu_text = start_of_name_definition + this.field_4_length_name_definition;
        this.field_14_custom_menu_text = new String(data, start_of_custom_menu_text + offset, LittleEndian.ubyteToInt(this.field_7_length_custom_menu));
        int start_of_description_text = start_of_custom_menu_text + this.field_8_length_description_text;
        this.field_15_description_text = new String(data, start_of_description_text + offset, LittleEndian.ubyteToInt(this.field_8_length_description_text));
        int start_of_help_topic_text = start_of_description_text + this.field_9_length_help_topic_text;
        this.field_16_help_topic_text = new String(data, start_of_help_topic_text + offset, LittleEndian.ubyteToInt(this.field_9_length_help_topic_text));
        int start_of_status_bar_text = start_of_help_topic_text + this.field_10_length_status_bar_text;
        this.field_17_status_bar_text = new String(data, start_of_status_bar_text + offset, LittleEndian.ubyteToInt(this.field_10_length_status_bar_text));
    }

    private Stack getParsedExpressionTokens(byte[] data, short size, int offset, int start_of_expression) {
        Stack<Ptg> stack = new Stack<Ptg>();
        int pos = start_of_expression + offset;
        int sizeCounter = 0;
        try {
            while (sizeCounter < size) {
                Ptg ptg = Ptg.createPtg(data, pos);
                pos += ptg.getSize();
                sizeCounter += ptg.getSize();
                stack.push(ptg);
            }
        }
        catch (UnsupportedOperationException uoe) {
            System.err.println("[WARNING] Unknown Ptg " + uoe.getMessage());
            this.field_13_raw_name_definition = new byte[size];
            System.arraycopy(data, offset, this.field_13_raw_name_definition, 0, size);
            return null;
        }
        return stack;
    }

    public short getSid() {
        return 24;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[NAME]\n");
        buffer.append("    .option flags         = ").append(HexDump.toHex(this.field_1_option_flag)).append("\n");
        buffer.append("    .keyboard shortcut    = ").append(HexDump.toHex(this.field_2_keyboard_shortcut)).append("\n");
        buffer.append("    .length of the name   = ").append(this.field_3_length_name_text).append("\n");
        buffer.append("    .size of the formula data = ").append(this.field_4_length_name_definition).append("\n");
        buffer.append("    .unused                   = ").append(this.field_5_index_to_sheet).append("\n");
        buffer.append("    .( 0 = Global name, otherwise index to sheet (one-based) ) = ").append(this.field_6_equals_to_index_to_sheet).append("\n");
        buffer.append("    .Length of menu text (character count)        = ").append(this.field_7_length_custom_menu).append("\n");
        buffer.append("    .Length of description text (character count) = ").append(this.field_8_length_description_text).append("\n");
        buffer.append("    .Length of help topic text (character count)  = ").append(this.field_9_length_help_topic_text).append("\n");
        buffer.append("    .Length of status bar text (character count)  = ").append(this.field_10_length_status_bar_text).append("\n");
        buffer.append("    .Name (Unicode flag)  = ").append(this.field_11_compressed_unicode_flag).append("\n");
        buffer.append("    .Name (Unicode text)  = ").append(this.field_12_name_text).append("\n");
        buffer.append("    .Formula data (RPN token array without size field)      = ").append(HexDump.toHex(this.field_13_raw_name_definition != null ? this.field_13_raw_name_definition : new byte[]{})).append("\n");
        buffer.append("    .Menu text (Unicode string without length field)        = ").append(this.field_14_custom_menu_text).append("\n");
        buffer.append("    .Description text (Unicode string without length field) = ").append(this.field_15_description_text).append("\n");
        buffer.append("    .Help topic text (Unicode string without length field)  = ").append(this.field_16_help_topic_text).append("\n");
        buffer.append("    .Status bar text (Unicode string without length field)  = ").append(this.field_17_status_bar_text).append("\n");
        buffer.append("[/NAME]\n");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

