/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class MulBlankRecord
extends Record {
    public static final short sid = 190;
    private int field_1_row;
    private short field_2_first_col;
    private short[] field_3_xfs;
    private short field_4_last_col;

    public MulBlankRecord() {
    }

    public MulBlankRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public MulBlankRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int coffset) {
        return this.field_3_xfs[coffset];
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_row = LittleEndian.getUShort(data, 0 + offset);
        this.field_2_first_col = LittleEndian.getShort(data, 2 + offset);
        this.field_3_xfs = this.parseXFs(data, 4, offset, size);
        this.field_4_last_col = LittleEndian.getShort(data, this.field_3_xfs.length * 2 + 4 + offset);
    }

    private short[] parseXFs(byte[] data, int offset, int recoffset, short size) {
        short[] retval = new short[(size - offset - 2) / 2];
        int idx = 0;
        while (offset < size - 2) {
            short xf = 0;
            xf = LittleEndian.getShort(data, offset + recoffset);
            offset += 2;
            retval[idx] = xf;
            ++idx;
        }
        return retval;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MULBLANK]\n");
        buffer.append("row  = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        int k = 0;
        while (k < this.getNumColumns()) {
            buffer.append("xf").append(k).append("        = ").append(Integer.toHexString(this.getXFAt(k))).append("\n");
            ++k;
        }
        buffer.append("[/MULBLANK]\n");
        return buffer.toString();
    }

    protected void validateSid(short id) {
        if (id != 190) {
            throw new RecordFormatException("Not a MulBlankRecord!");
        }
    }

    public short getSid() {
        return 190;
    }

    public int serialize(int offset, byte[] data) {
        throw new RecordFormatException("Sorry, you can't serialize a MulBlank in this release");
    }
}

