/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class HeaderRecord
extends Record {
    public static final short sid = 20;
    private byte field_1_header_len;
    private String field_2_header;

    public HeaderRecord() {
    }

    public HeaderRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public HeaderRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 20) {
            throw new RecordFormatException("NOT A HEADERRECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        if (size > 0) {
            this.field_1_header_len = data[0 + offset];
            this.field_2_header = new String(data, 3 + offset, LittleEndian.ubyteToInt(this.field_1_header_len));
        }
    }

    public void setHeaderLength(byte len) {
        this.field_1_header_len = len;
    }

    public void setHeader(String header) {
        this.field_2_header = header;
    }

    public short getHeaderLength() {
        return (short)(0xFF & this.field_1_header_len);
    }

    public String getHeader() {
        return this.field_2_header;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HEADER]\n");
        buffer.append("    .length         = ").append(this.getHeaderLength()).append("\n");
        buffer.append("    .header         = ").append(this.getHeader()).append("\n");
        buffer.append("[/HEADER]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int len = 4;
        if (this.getHeaderLength() != 0) {
            len += 3;
        }
        LittleEndian.putShort(data, 0 + offset, (short)20);
        LittleEndian.putShort(data, 2 + offset, (short)(len - 4 + this.getHeaderLength()));
        if (this.getHeaderLength() > 0) {
            data[4 + offset] = (byte)this.getHeaderLength();
            StringUtil.putCompressedUnicode(this.getHeader(), data, 7 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.getHeaderLength() != 0) {
            retval += 3;
        }
        return retval += this.getHeaderLength();
    }

    public short getSid() {
        return 20;
    }

    public Object clone() {
        HeaderRecord rec = new HeaderRecord();
        rec.field_1_header_len = this.field_1_header_len;
        rec.field_2_header = this.field_2_header;
        return rec;
    }
}

