/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FormatRecord
extends Record {
    public static final short sid = 1054;
    private short field_1_index_code;
    private short field_2_formatstring_len;
    private short field_3_unicode_len;
    private boolean field_3_unicode_flag;
    private String field_4_formatstring;

    public FormatRecord() {
    }

    public FormatRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public FormatRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 1054) {
            throw new RecordFormatException("NOT A FORMAT RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_index_code = LittleEndian.getShort(data, 0 + offset);
        this.field_2_formatstring_len = this.field_3_unicode_len = LittleEndian.getShort(data, 2 + offset);
        this.field_3_unicode_flag = (data[4 + offset] & 1) != 0;
        this.field_4_formatstring = this.field_3_unicode_flag ? StringUtil.getFromUnicodeHigh(data, 5 + offset, this.field_3_unicode_len) : new String(data, 5 + offset, (int)this.field_3_unicode_len);
    }

    public void setIndexCode(short index) {
        this.field_1_index_code = index;
    }

    public void setFormatStringLength(byte len) {
        this.field_2_formatstring_len = len;
        this.field_3_unicode_len = len;
    }

    public void setUnicodeFlag(boolean unicode) {
        this.field_3_unicode_flag = unicode;
    }

    public void setFormatString(String fs) {
        this.field_4_formatstring = fs;
    }

    public short getIndexCode() {
        return this.field_1_index_code;
    }

    public short getFormatStringLength() {
        return this.field_3_unicode_flag ? this.field_3_unicode_len : this.field_2_formatstring_len;
    }

    public boolean getUnicodeFlag() {
        return this.field_3_unicode_flag;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMAT]\n");
        buffer.append("    .indexcode       = ").append(Integer.toHexString(this.getIndexCode())).append("\n");
        buffer.append("    .unicode length  = ").append(Integer.toHexString(this.field_3_unicode_len)).append("\n");
        buffer.append("    .isUnicode       = ").append(this.field_3_unicode_flag).append("\n");
        buffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        buffer.append("[/FORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)1054);
        LittleEndian.putShort(data, 2 + offset, (short)(5 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len)));
        LittleEndian.putShort(data, 4 + offset, this.getIndexCode());
        LittleEndian.putShort(data, 6 + offset, this.field_3_unicode_len);
        byte by = data[8 + offset] = this.field_3_unicode_flag ? (byte)1 : 0;
        if (this.field_3_unicode_flag) {
            StringUtil.putUncompressedUnicode(this.getFormatString(), data, 9 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.getFormatString(), data, 9 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 9 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len);
    }

    public short getSid() {
        return 1054;
    }
}

