/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.IntList;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Sheet
implements Model {
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    protected ArrayList records = null;
    int preoffset = 0;
    int loc = 0;
    protected boolean containsLabels = false;
    protected int dimsloc = 0;
    protected DimensionsRecord dims;
    protected DefaultColWidthRecord defaultcolwidth = null;
    protected DefaultRowHeightRecord defaultrowheight = null;
    protected GridsetRecord gridset = null;
    protected PrintSetupRecord printSetup = null;
    protected HeaderRecord header = null;
    protected FooterRecord footer = null;
    protected PrintGridlinesRecord printGridlines = null;
    protected MergeCellsRecord merged = null;
    protected SelectionRecord selection = null;
    protected int mergedloc = 0;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$model$Sheet == null ? (class$org$apache$poi$hssf$model$Sheet = Sheet.class$("org.apache.poi.hssf.model.Sheet")) : class$org$apache$poi$hssf$model$Sheet);
    private ArrayList columnSizes = null;
    protected ValueRecordsAggregate cells = null;
    protected RowRecordsAggregate rows = null;
    private Iterator valueRecIterator = null;
    private Iterator rowRecIterator = null;
    protected int eofLoc = 0;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    static /* synthetic */ Class class$org$apache$poi$hssf$model$Sheet;

    public static Sheet createSheet(List recs, int sheetnum, int offset) {
        log.logFormatted(1, "Sheet createSheet (existing file) with %", new Integer(recs.size()));
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(recs.size() / 5);
        boolean isfirstcell = true;
        boolean isfirstrow = true;
        int bofEofNestingLevel = 0;
        int k = offset;
        while (k < recs.size()) {
            Record rec = (Record)recs.get(k);
            if (rec.getSid() == 516) {
                log.log(1, "Hit label record.");
                retval.containsLabels = true;
            } else if (rec.getSid() == 2057) {
                log.log(1, "Hit BOF record. Nesting increased to " + ++bofEofNestingLevel);
            } else if (rec.getSid() == 10) {
                log.log(1, "Hit EOF record. Nesting decreased to " + --bofEofNestingLevel);
                if (bofEofNestingLevel == 0) {
                    records.add(rec);
                    retval.eofLoc = k;
                    break;
                }
            } else if (rec.getSid() == 512) {
                retval.dims = (DimensionsRecord)rec;
                retval.dimsloc = records.size();
            } else if (rec.getSid() == 229) {
                retval.merged = (MergeCellsRecord)rec;
                retval.mergedloc = k - offset;
            } else if (rec.getSid() == 125) {
                if (retval.columnSizes == null) {
                    retval.columnSizes = new ArrayList();
                }
                retval.columnSizes.add(rec);
            } else if (rec.getSid() == 85) {
                retval.defaultcolwidth = (DefaultColWidthRecord)rec;
            } else if (rec.getSid() == 549) {
                retval.defaultrowheight = (DefaultRowHeightRecord)rec;
            } else if (rec.isValue() && bofEofNestingLevel == 1) {
                if (isfirstcell) {
                    retval.cells = new ValueRecordsAggregate();
                    rec = retval.cells;
                    retval.cells.construct(k, recs);
                    isfirstcell = false;
                } else {
                    rec = null;
                }
            } else if (rec.getSid() == 519) {
                rec = null;
            } else if (rec.getSid() == 520) {
                if (isfirstrow) {
                    retval.rows = new RowRecordsAggregate();
                    rec = retval.rows;
                    retval.rows.construct(k, recs);
                    isfirstrow = false;
                } else {
                    rec = null;
                }
            } else if (rec.getSid() == 43) {
                retval.printGridlines = (PrintGridlinesRecord)rec;
            } else if (rec.getSid() == 20) {
                retval.header = (HeaderRecord)rec;
            } else if (rec.getSid() == 21) {
                retval.footer = (FooterRecord)rec;
            } else if (rec.getSid() == 161) {
                retval.printSetup = (PrintSetupRecord)rec;
            } else if (rec.getSid() == 29) {
                retval.selection = (SelectionRecord)rec;
            }
            if (rec != null) {
                records.add(rec);
            }
            ++k;
        }
        retval.records = records;
        if (retval.rows == null) {
            retval.rows = new RowRecordsAggregate();
        }
        if (retval.cells == null) {
            retval.cells = new ValueRecordsAggregate();
        }
        log.log(1, "sheet createSheet (existing file) exited");
        return retval;
    }

    public Sheet cloneSheet() {
        ArrayList<Record> clonedRecords = new ArrayList<Record>(this.records.size());
        int i = 0;
        while (i < this.records.size()) {
            Record rec = (Record)((Record)this.records.get(i)).clone();
            if (rec instanceof RowRecordsAggregate) {
                RowRecordsAggregate rrAgg = (RowRecordsAggregate)rec;
                Iterator rowIter = rrAgg.getIterator();
                while (rowIter.hasNext()) {
                    Record rowRec = (Record)rowIter.next();
                    clonedRecords.add(rowRec);
                }
            } else if (rec instanceof ValueRecordsAggregate) {
                ValueRecordsAggregate vrAgg = (ValueRecordsAggregate)rec;
                Iterator cellIter = vrAgg.getIterator();
                while (cellIter.hasNext()) {
                    Record valRec = (Record)cellIter.next();
                    clonedRecords.add(valRec);
                }
            } else if (rec instanceof FormulaRecordAggregate) {
                FormulaRecordAggregate fmAgg = (FormulaRecordAggregate)rec;
                Record fmAggRec = fmAgg.getFormulaRecord();
                if (fmAggRec != null) {
                    clonedRecords.add(fmAggRec);
                }
                if ((fmAggRec = fmAgg.getStringRecord()) != null) {
                    clonedRecords.add(fmAggRec);
                }
            } else {
                clonedRecords.add(rec);
            }
            ++i;
        }
        return Sheet.createSheet(clonedRecords, 0, 0);
    }

    public static Sheet createSheet(List records, int sheetnum) {
        log.log(1, "Sheet createSheet (exisiting file) assumed offset 0");
        return Sheet.createSheet(records, sheetnum, 0);
    }

    public static Sheet createSheet() {
        log.log(1, "Sheet createsheet from scratch called");
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(30);
        records.add(retval.createBOF());
        records.add(retval.createCalcMode());
        records.add(retval.createCalcCount());
        records.add(retval.createRefMode());
        records.add(retval.createIteration());
        records.add(retval.createDelta());
        records.add(retval.createSaveRecalc());
        records.add(retval.createPrintHeaders());
        retval.printGridlines = (PrintGridlinesRecord)retval.createPrintGridlines();
        records.add(retval.printGridlines);
        retval.gridset = (GridsetRecord)retval.createGridset();
        records.add(retval.gridset);
        records.add(retval.createGuts());
        retval.defaultrowheight = (DefaultRowHeightRecord)retval.createDefaultRowHeight();
        records.add(retval.defaultrowheight);
        records.add(retval.createWSBool());
        retval.header = (HeaderRecord)retval.createHeader();
        records.add(retval.header);
        retval.footer = (FooterRecord)retval.createFooter();
        records.add(retval.footer);
        records.add(retval.createHCenter());
        records.add(retval.createVCenter());
        retval.printSetup = (PrintSetupRecord)retval.createPrintSetup();
        records.add(retval.printSetup);
        retval.defaultcolwidth = (DefaultColWidthRecord)retval.createDefaultColWidth();
        records.add(retval.defaultcolwidth);
        retval.dims = (DimensionsRecord)retval.createDimensions();
        retval.dimsloc = 19;
        records.add(retval.dims);
        records.add(retval.createWindowTwo());
        retval.setLoc(records.size() - 1);
        retval.selection = (SelectionRecord)retval.createSelection();
        records.add(retval.selection);
        records.add(retval.createEOF());
        retval.records = records;
        log.log(1, "Sheet createsheet from scratch exit");
        return retval;
    }

    private void checkCells() {
        if (this.cells == null) {
            this.cells = new ValueRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.cells);
        }
    }

    private void checkRows() {
        if (this.rows == null) {
            this.rows = new RowRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.rows);
        }
    }

    public int addMergedRegion(int rowFrom, short colFrom, int rowTo, short colTo) {
        if (this.merged == null) {
            this.merged = (MergeCellsRecord)this.createMergedCells();
            this.mergedloc = this.records.size() - 1;
            this.records.add(this.records.size() - 1, this.merged);
        }
        return this.merged.addArea(rowFrom, colFrom, rowTo, colTo);
    }

    public void removeMergedRegion(int index) {
        this.merged.removeAreaAt(index);
        if (this.merged.getNumAreas() == 0) {
            this.merged = null;
            this.records.remove(this.mergedloc);
            this.mergedloc = 0;
        }
    }

    public MergeCellsRecord.MergedRegion getMergedRegionAt(int index) {
        return this.merged.getAreaAt(index);
    }

    public int getNumMergedRegions() {
        return this.merged != null ? (int)this.merged.getNumAreas() : 0;
    }

    public void convertLabelRecords(Workbook wb) {
        log.log(1, "convertLabelRecords called");
        if (this.containsLabels) {
            int k = 0;
            while (k < this.records.size()) {
                Record rec = (Record)this.records.get(k);
                if (rec.getSid() == 516) {
                    LabelRecord oldrec = (LabelRecord)rec;
                    this.records.remove(k);
                    LabelSSTRecord newrec = new LabelSSTRecord();
                    int stringid = wb.addSSTString(oldrec.getValue());
                    newrec.setRow(oldrec.getRow());
                    newrec.setColumn(oldrec.getColumn());
                    newrec.setXFIndex(oldrec.getXFIndex());
                    newrec.setSSTIndex(stringid);
                    this.records.add(k, newrec);
                }
                ++k;
            }
        }
        log.log(1, "convertLabelRecords exit");
    }

    public int getNumRecords() {
        this.checkCells();
        this.checkRows();
        log.log(1, "Sheet.getNumRecords");
        log.logFormatted(1, "returning % + % + % - 2 = %", new int[]{this.records.size(), this.cells.getPhysicalNumberOfCells(), this.rows.getPhysicalNumberOfRows(), this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2});
        return this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2;
    }

    public void setDimensions(int firstrow, short firstcol, int lastrow, short lastcol) {
        log.log(1, "Sheet.setDimensions");
        log.log(1, "firstrow" + firstrow + "firstcol" + firstcol + "lastrow" + lastrow + "lastcol" + lastcol);
        this.dims.setFirstCol(firstcol);
        this.dims.setFirstRow(firstrow);
        this.dims.setLastCol(lastcol);
        this.dims.setLastRow(lastrow);
        log.log(1, "Sheet.setDimensions exiting");
    }

    public void setLoc(int loc) {
        this.valueRecIterator = null;
        log.log(1, "sheet.setLoc(): " + loc);
        this.loc = loc;
    }

    public int getLoc() {
        log.log(1, "sheet.getLoc():" + this.loc);
        return this.loc;
    }

    public void setPreOffset(int offset) {
        this.preoffset = offset;
    }

    public int getPreOffset() {
        return this.preoffset;
    }

    public byte[] serialize() {
        log.log(1, "Sheet.serialize");
        byte[] retval = null;
        int arraysize = this.getSize();
        int pos = 0;
        retval = new byte[arraysize];
        int k = 0;
        while (k < this.records.size()) {
            pos += ((Record)this.records.get(k)).serialize(pos, retval);
            ++k;
        }
        log.log(1, "Sheet.serialize returning " + retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        log.log(1, "Sheet.serialize using offsets");
        int pos = 0;
        int k = 0;
        while (k < this.records.size()) {
            Record record = (Record)this.records.get(k);
            pos += record.serialize(pos + offset, data);
            ++k;
        }
        log.log(1, "Sheet.serialize returning ");
        return pos;
    }

    public RowRecord createRow(int row) {
        log.log(1, "create row number " + row);
        RowRecord rowrec = new RowRecord();
        rowrec.setRowNumber(row);
        rowrec.setHeight((short)255);
        rowrec.setOptimize((short)0);
        rowrec.setOptionFlags((short)0);
        rowrec.setXFIndex((short)0);
        return rowrec;
    }

    public LabelSSTRecord createLabelSST(int row, short col, int index) {
        log.logFormatted(1, "create labelsst row,col,index %,%,%", new int[]{row, col, index});
        LabelSSTRecord rec = new LabelSSTRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setSSTIndex(index);
        rec.setXFIndex((short)15);
        return rec;
    }

    public NumberRecord createNumber(int row, short col, double value) {
        log.logFormatted(1, "create number row,col,value %,%,%", new double[]{row, col, value});
        NumberRecord rec = new NumberRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setValue(value);
        rec.setXFIndex((short)15);
        return rec;
    }

    public BlankRecord createBlank(int row, short col) {
        log.logFormatted(1, "create blank row,col %,%", new int[]{row, col});
        BlankRecord rec = new BlankRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setXFIndex((short)15);
        return rec;
    }

    public FormulaRecord createFormula(int row, short col, String formula) {
        log.logFormatted(1, "create formula row,col,formula %,%,%", new int[]{row, col}, formula);
        FormulaRecord rec = new FormulaRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setOptions((short)2);
        rec.setValue(0.0);
        rec.setXFIndex((short)15);
        FormulaParser fp = new FormulaParser(formula, null);
        fp.parse();
        Ptg[] ptg = fp.getRPNPtg();
        int size = 0;
        int k = 0;
        while (k < ptg.length) {
            size += ptg[k].getSize();
            rec.pushExpressionToken(ptg[k]);
            ++k;
        }
        rec.setExpressionLength((short)size);
        return rec;
    }

    public void addValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        log.logFormatted(1, "add value record  row,loc %,%", new int[]{row, this.loc});
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (col.getColumn() > d.getLastCol()) {
            d.setLastCol((short)(col.getColumn() + 1));
        }
        if (col.getColumn() < d.getFirstCol()) {
            d.setFirstCol(col.getColumn());
        }
        this.cells.insertCell(col);
    }

    public void removeValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        log.logFormatted(1, "remove value record row,dimsloc %,%", new int[]{row, this.dimsloc});
        this.loc = this.dimsloc;
        this.cells.removeCell(col);
    }

    public void replaceValueRecord(CellValueRecordInterface newval) {
        this.checkCells();
        this.setLoc(this.dimsloc);
        log.log(1, "replaceValueRecord ");
        this.cells.insertCell(newval);
    }

    public void addRow(RowRecord row) {
        RowRecord existingRow;
        this.checkRows();
        log.log(1, "addRow ");
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (row.getRowNumber() > d.getLastRow()) {
            d.setLastRow(row.getRowNumber() + 1);
        }
        if (row.getRowNumber() < d.getFirstRow()) {
            d.setFirstRow(row.getRowNumber());
        }
        if ((existingRow = this.rows.getRow(row.getRowNumber())) != null) {
            this.rows.removeRow(existingRow);
        }
        this.rows.insertRow(row);
        log.log(1, "exit addRow");
    }

    public void removeRow(RowRecord row) {
        this.checkRows();
        this.setLoc(this.getDimsLoc());
        this.rows.removeRow(row);
    }

    public CellValueRecordInterface getNextValueRecord() {
        log.log(1, "getNextValue loc= " + this.loc);
        if (this.valueRecIterator == null) {
            this.valueRecIterator = this.cells.getIterator();
        }
        if (!this.valueRecIterator.hasNext()) {
            return null;
        }
        return (CellValueRecordInterface)this.valueRecIterator.next();
    }

    public RowRecord getNextRow() {
        log.log(1, "getNextRow loc= " + this.loc);
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this.rows.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return (RowRecord)this.rowRecIterator.next();
    }

    public RowRecord getRow(int rownum) {
        log.log(1, "getNextRow loc= " + this.loc);
        return this.rows.getRow(rownum);
    }

    public void addDBCellRecords() {
        Record rec;
        int offset = 0;
        int recnum = 0;
        int rownum = 0;
        IndexRecord index = null;
        IntList rowOffsets = new IntList();
        recnum = 0;
        while (recnum < this.records.size()) {
            rec = (Record)this.records.get(recnum);
            if (rec.getSid() == 523) {
                index = (IndexRecord)rec;
            }
            if (rec.getSid() == 520) break;
            offset += rec.serialize().length;
            ++recnum;
        }
        while (recnum < this.records.size()) {
            rec = (Record)this.records.get(recnum);
            if (rec.getSid() == 520) {
                rowOffsets.add(offset);
                if (++rownum % 32 == 0) {
                    int rn = recnum;
                    while (rn < this.records.size()) {
                        rec = (Record)this.records.get(rn);
                        if (!rec.isInValueSection() || rec.getSid() == 520) {
                            this.records.add(rn, this.createDBCell(offset, rowOffsets, index));
                            recnum = rn;
                            break;
                        }
                        ++rn;
                    }
                }
            }
            if (!rec.isInValueSection()) {
                this.records.add(recnum, this.createDBCell(offset, rowOffsets, index));
                break;
            }
            offset += rec.serialize().length;
            ++recnum;
        }
    }

    private DBCellRecord createDBCell(int offset, IntList rowoffsets, IndexRecord index) {
        DBCellRecord rec = new DBCellRecord();
        rec.setRowOffset(offset - rowoffsets.get(0));
        rec.addCellOffset((short)0);
        this.addDbCellToIndex(offset, index);
        return rec;
    }

    private void addDbCellToIndex(int offset, IndexRecord index) {
        int numdbcells = index.getNumDbcells() + 1;
        index.addDbcell(offset + this.preoffset);
        int k = 0;
        while (k < numdbcells) {
            int dbval = index.getDbcellAt(k);
            index.setDbcell(k, dbval + 4);
            ++k;
        }
    }

    protected Record createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)16);
        retval.setBuild((short)3515);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(193);
        retval.setRequiredVersion(6);
        return retval;
    }

    protected Record createIndex() {
        IndexRecord retval = new IndexRecord();
        retval.setFirstRow(0);
        retval.setLastRowAdd1(0);
        return retval;
    }

    protected Record createCalcMode() {
        CalcModeRecord retval = new CalcModeRecord();
        retval.setCalcMode((short)1);
        return retval;
    }

    protected Record createCalcCount() {
        CalcCountRecord retval = new CalcCountRecord();
        retval.setIterations((short)100);
        return retval;
    }

    protected Record createRefMode() {
        RefModeRecord retval = new RefModeRecord();
        retval.setMode((short)1);
        return retval;
    }

    protected Record createIteration() {
        IterationRecord retval = new IterationRecord();
        retval.setIteration(false);
        return retval;
    }

    protected Record createDelta() {
        DeltaRecord retval = new DeltaRecord();
        retval.setMaxChange(0.001);
        return retval;
    }

    protected Record createSaveRecalc() {
        SaveRecalcRecord retval = new SaveRecalcRecord();
        retval.setRecalc(true);
        return retval;
    }

    protected Record createPrintHeaders() {
        PrintHeadersRecord retval = new PrintHeadersRecord();
        retval.setPrintHeaders(false);
        return retval;
    }

    protected Record createPrintGridlines() {
        PrintGridlinesRecord retval = new PrintGridlinesRecord();
        retval.setPrintGridlines(false);
        return retval;
    }

    protected Record createGridset() {
        GridsetRecord retval = new GridsetRecord();
        retval.setGridset(true);
        return retval;
    }

    protected Record createGuts() {
        GutsRecord retval = new GutsRecord();
        retval.setLeftRowGutter((short)0);
        retval.setTopColGutter((short)0);
        retval.setRowLevelMax((short)0);
        retval.setColLevelMax((short)0);
        return retval;
    }

    protected Record createDefaultRowHeight() {
        DefaultRowHeightRecord retval = new DefaultRowHeightRecord();
        retval.setOptionFlags((short)0);
        retval.setRowHeight((short)255);
        return retval;
    }

    protected Record createWSBool() {
        WSBoolRecord retval = new WSBoolRecord();
        retval.setWSBool1((byte)4);
        retval.setWSBool2((byte)-63);
        return retval;
    }

    protected Record createHeader() {
        HeaderRecord retval = new HeaderRecord();
        retval.setHeaderLength((byte)0);
        retval.setHeader(null);
        return retval;
    }

    protected Record createFooter() {
        FooterRecord retval = new FooterRecord();
        retval.setFooterLength((byte)0);
        retval.setFooter(null);
        return retval;
    }

    protected Record createHCenter() {
        HCenterRecord retval = new HCenterRecord();
        retval.setHCenter(false);
        return retval;
    }

    protected Record createVCenter() {
        VCenterRecord retval = new VCenterRecord();
        retval.setVCenter(false);
        return retval;
    }

    protected Record createPrintSetup() {
        PrintSetupRecord retval = new PrintSetupRecord();
        retval.setPaperSize((short)1);
        retval.setScale((short)100);
        retval.setPageStart((short)1);
        retval.setFitWidth((short)1);
        retval.setFitHeight((short)1);
        retval.setOptions((short)2);
        retval.setHResolution((short)300);
        retval.setVResolution((short)300);
        retval.setHeaderMargin(0.5);
        retval.setFooterMargin(0.5);
        retval.setCopies((short)0);
        return retval;
    }

    protected Record createDefaultColWidth() {
        DefaultColWidthRecord retval = new DefaultColWidthRecord();
        retval.setColWidth((short)8);
        return retval;
    }

    protected Record createColInfo() {
        ColumnInfoRecord retval = new ColumnInfoRecord();
        retval.setColumnWidth((short)8);
        retval.setOptions((short)6);
        retval.setXFIndex((short)15);
        return retval;
    }

    public short getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public boolean isGridsPrinted() {
        return !this.gridset.getGridset();
    }

    public void setGridsPrinted(boolean value) {
        this.gridset.setGridset(!value);
    }

    public void setDefaultColumnWidth(short dcw) {
        this.defaultcolwidth.setColWidth(dcw);
    }

    public void setDefaultRowHeight(short dch) {
        this.defaultrowheight.setRowHeight(dch);
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public short getColumnWidth(short column) {
        short retval = 0;
        ColumnInfoRecord ci = null;
        int k = 0;
        if (this.columnSizes != null) {
            k = 0;
            while (k < this.columnSizes.size()) {
                ci = (ColumnInfoRecord)this.columnSizes.get(k);
                if (ci.getFirstColumn() >= column && column <= ci.getLastColumn()) break;
                ci = null;
                ++k;
            }
        }
        retval = ci != null ? ci.getColumnWidth() : this.defaultcolwidth.getColWidth();
        return retval;
    }

    public void setColumnWidth(short column, short width) {
        ColumnInfoRecord ci = null;
        int k = 0;
        if (this.columnSizes == null) {
            this.columnSizes = new ArrayList();
        }
        k = 0;
        while (k < this.columnSizes.size()) {
            ci = (ColumnInfoRecord)this.columnSizes.get(k);
            if (ci.getFirstColumn() >= column && column <= ci.getLastColumn()) break;
            ci = null;
            ++k;
        }
        if (ci != null) {
            if (ci.getColumnWidth() != width) {
                if (ci.getFirstColumn() == column && ci.getLastColumn() == column) {
                    ci.setColumnWidth(width);
                } else if (ci.getFirstColumn() == column || ci.getLastColumn() == column) {
                    if (ci.getFirstColumn() == column) {
                        ci.setFirstColumn((short)(column + 1));
                    } else {
                        ci.setLastColumn((short)(column - 1));
                    }
                    ColumnInfoRecord nci = (ColumnInfoRecord)this.createColInfo();
                    nci.setFirstColumn(column);
                    nci.setLastColumn(column);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    nci.setColumnWidth(width);
                    this.columnSizes.add(k, nci);
                    this.records.add(1 + this.getDimsLoc() - this.columnSizes.size() + k, nci);
                    ++this.dimsloc;
                }
            }
        } else {
            ColumnInfoRecord nci = (ColumnInfoRecord)this.createColInfo();
            nci.setFirstColumn(column);
            nci.setLastColumn(column);
            nci.setColumnWidth(width);
            this.columnSizes.add(k, nci);
            this.records.add(1 + this.getDimsLoc() - this.columnSizes.size() + k, nci);
            ++this.dimsloc;
        }
    }

    protected Record createDimensions() {
        DimensionsRecord retval = new DimensionsRecord();
        retval.setFirstCol((short)0);
        retval.setLastRow(1);
        retval.setFirstRow(0);
        retval.setLastCol((short)1);
        return retval;
    }

    protected Record createWindowTwo() {
        WindowTwoRecord retval = new WindowTwoRecord();
        retval.setOptions((short)1718);
        retval.setTopRow((short)0);
        retval.setLeftCol((short)0);
        retval.setHeaderColor(64);
        retval.setPageBreakZoom((short)0);
        retval.setNormalZoom((short)0);
        return retval;
    }

    protected Record createSelection() {
        SelectionRecord retval = new SelectionRecord();
        retval.setPane((byte)3);
        retval.setActiveCellCol((short)0);
        retval.setActiveCellRow(0);
        retval.setNumRefs((short)0);
        return retval;
    }

    public int getActiveCellRow() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellRow();
    }

    public void setActiveCellRow(int row) {
        if (this.selection != null) {
            this.selection.setActiveCellRow(row);
        }
    }

    public short getActiveCellCol() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellCol();
    }

    public void setActiveCellCol(short col) {
        if (this.selection != null) {
            this.selection.setActiveCellCol(col);
        }
    }

    protected Record createMergedCells() {
        MergeCellsRecord retval = new MergeCellsRecord();
        retval.setNumAreas((short)0);
        return retval;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    public int getDimsLoc() {
        log.log(1, "getDimsLoc dimsloc= " + this.dimsloc);
        return this.dimsloc;
    }

    public void checkDimsLoc(Record rec, int recloc) {
        if (rec.getSid() == 512) {
            this.loc = recloc;
            this.dimsloc = recloc;
        }
    }

    public int getSize() {
        int retval = 0;
        int k = 0;
        while (k < this.records.size()) {
            retval += ((Record)this.records.get(k)).getRecordSize();
            ++k;
        }
        return retval;
    }

    public List getRecords() {
        return this.records;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public Record findFirstRecordBySid(short sid) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid) continue;
            return record;
        }
        return null;
    }

    public void setSCLRecord(SCLRecord sclRecord) {
        int oldRecordLoc = this.findFirstRecordLocBySid((short)160);
        if (oldRecordLoc == -1) {
            int windowRecordLoc = this.findFirstRecordLocBySid((short)574);
            this.records.add(windowRecordLoc + 1, sclRecord);
        } else {
            this.records.set(oldRecordLoc, sclRecord);
        }
    }

    public int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public HeaderRecord getHeader() {
        return this.header;
    }

    public void setHeader(HeaderRecord newHeader) {
        this.header = newHeader;
    }

    public FooterRecord getFooter() {
        return this.footer;
    }

    public void setFooter(FooterRecord newFooter) {
        this.footer = newFooter;
    }

    public PrintSetupRecord getPrintSetup() {
        return this.printSetup;
    }

    public void setPrintSetup(PrintSetupRecord newPrintSetup) {
        this.printSetup = newPrintSetup;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public void setPrintGridlines(PrintGridlinesRecord newPrintGridlines) {
        this.printGridlines = newPrintGridlines;
    }

    public void setSelected(boolean sel) {
        WindowTwoRecord windowTwo = (WindowTwoRecord)this.findFirstRecordBySid((short)574);
        windowTwo.setSelected(sel);
    }

    public double getMargin(short margin) {
        Margin m;
        switch (margin) {
            case 0: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)38));
                if (m != null) break;
                return 0.75;
            }
            case 1: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)39));
                if (m != null) break;
                return 0.75;
            }
            case 2: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)40));
                if (m != null) break;
                return 1.0;
            }
            case 3: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)41));
                if (m != null) break;
                return 1.0;
            }
            default: {
                throw new RuntimeException("Unknown margin constant:  " + margin);
            }
        }
        return m.getMargin();
    }

    public void setMargin(short margin, double size) {
        Margin m;
        switch (margin) {
            case 0: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)38));
                if (m != null) break;
                m = new LeftMarginRecord();
                this.records.add(this.getDimsLoc() + 1, m);
                break;
            }
            case 1: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)39));
                if (m != null) break;
                m = new RightMarginRecord();
                this.records.add(this.getDimsLoc() + 1, m);
                break;
            }
            case 2: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)40));
                if (m != null) break;
                m = new TopMarginRecord();
                this.records.add(this.getDimsLoc() + 1, m);
                break;
            }
            case 3: {
                m = (Margin)((Object)this.findFirstRecordBySid((short)41));
                if (m != null) break;
                m = new BottomMarginRecord();
                this.records.add(this.getDimsLoc() + 1, m);
                break;
            }
            default: {
                throw new RuntimeException("Unknown margin constant:  " + margin);
            }
        }
        m.setMargin(size);
    }

    public int getEofLoc() {
        return this.eofLoc;
    }

    public void createFreezePane(int colSplit, int rowSplit, int topRow, int leftmostColumn) {
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord pane = new PaneRecord();
        pane.setX((short)colSplit);
        pane.setY((short)rowSplit);
        pane.setTopRow((short)topRow);
        pane.setLeftColumn((short)leftmostColumn);
        if (rowSplit == 0) {
            pane.setTopRow((short)0);
            pane.setActivePane((short)1);
        } else if (colSplit == 0) {
            pane.setLeftColumn((short)64);
            pane.setActivePane((short)2);
        } else {
            pane.setActivePane((short)0);
        }
        this.records.add(loc + 1, pane);
        WindowTwoRecord windowRecord = (WindowTwoRecord)this.records.get(loc);
        windowRecord.setFreezePanes(true);
        windowRecord.setFreezePanesNoSplit(true);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)pane.getActivePane());
        int selLoc = this.findFirstRecordLocBySid((short)29);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int topRow, int leftmostColumn, int activePane) {
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord r = new PaneRecord();
        r.setX((short)xSplitPos);
        r.setY((short)ySplitPos);
        r.setTopRow((short)topRow);
        r.setLeftColumn((short)leftmostColumn);
        r.setActivePane((short)activePane);
        this.records.add(loc + 1, r);
        WindowTwoRecord windowRecord = (WindowTwoRecord)this.records.get(loc);
        windowRecord.setFreezePanes(false);
        windowRecord.setFreezePanesNoSplit(false);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)0);
        int selLoc = this.findFirstRecordLocBySid((short)29);
    }

    public SelectionRecord getSelection() {
        return this.selection;
    }

    public void setSelection(SelectionRecord selection) {
        this.selection = selection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

