/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.hssf.model.Node;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.util.SheetReferences;

public class FormulaParser {
    public static int FORMULA_TYPE_CELL = 0;
    public static int FORMULA_TYPE_SHARED = 1;
    public static int FORMULA_TYPE_ARRAY = 2;
    public static int FORMULA_TYPE_CONDFOMRAT = 3;
    public static int FORMULA_TYPE_NAMEDRANGE = 4;
    private String formulaString;
    private int pointer = 0;
    private int formulaLength;
    private List tokens = new Stack();
    private List result = new ArrayList();
    private int numParen;
    private static char TAB = (char)9;
    private static char CR = (char)10;
    private char look;
    private Workbook book;

    public FormulaParser(String formula, Workbook book) {
        this.formulaString = formula;
        this.pointer = 0;
        this.book = book;
        this.formulaLength = this.formulaString.length();
    }

    private void GetChar() {
        if (this.pointer == this.formulaLength) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaString.charAt(this.pointer++);
    }

    private void Error(String s) {
        System.out.println("Error: " + s);
    }

    private void Abort(String s) {
        this.Error(s);
        throw new RuntimeException("Cannot Parse, sorry : " + s);
    }

    private void Expected(String s) {
        this.Abort(s + " Expected");
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsAddop(char c) {
        return c == '+' || c == '-';
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            this.Expected("" + x + "");
        } else {
            this.GetChar();
            this.SkipWhite();
        }
    }

    private String GetName() {
        StringBuffer Token = new StringBuffer();
        if (!this.IsAlpha(this.look)) {
            this.Expected("Name");
        }
        while (this.IsAlNum(this.look)) {
            Token = Token.append(Character.toUpperCase(this.look));
            this.GetChar();
        }
        this.SkipWhite();
        return Token.toString();
    }

    private String GetNameAsIs() {
        StringBuffer Token = new StringBuffer();
        if (!this.IsAlpha(this.look)) {
            this.Expected("Name");
        }
        while (this.IsAlNum(this.look) || this.IsWhite(this.look)) {
            Token = Token.append(this.look);
            this.GetChar();
        }
        return Token.toString();
    }

    private String GetNum() {
        String Value = "";
        if (!this.IsDigit(this.look)) {
            this.Expected("Integer");
        }
        while (this.IsDigit(this.look)) {
            Value = Value + this.look;
            this.GetChar();
        }
        this.SkipWhite();
        return Value;
    }

    private void Emit(String s) {
        System.out.print(TAB + s);
    }

    private void EmitLn(String s) {
        this.Emit(s);
        System.out.println();
    }

    private void Ident() {
        String name = this.GetName();
        if (this.look == '(') {
            this.function(name);
        } else if (this.look == ':') {
            String first = name;
            this.Match(':');
            String second = this.GetName();
            this.tokens.add(new AreaPtg(first + ":" + second));
        } else if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = this.GetName();
            short externIdx = this.book.checkExternSheet(this.book.getSheetIndex(sheetName));
            if (this.look == ':') {
                this.Match(':');
                String second = this.GetName();
                this.tokens.add(new Area3DPtg(first + ":" + second, externIdx));
            } else {
                this.tokens.add(new Ref3DPtg(first, externIdx));
            }
        } else {
            boolean boolLit;
            boolean cellRef = true;
            boolean bl = boolLit = name.equals("TRUE") || name.equals("FALSE");
            if (boolLit) {
                this.tokens.add(new BoolPtg(name));
            } else if (cellRef) {
                this.tokens.add(new ReferencePtg(name));
            }
        }
    }

    private void function(String name) {
        this.Match('(');
        int numArgs = this.Arguments();
        this.Match(')');
        this.tokens.add(this.getFunction(name, (byte)numArgs));
    }

    private Ptg getFunction(String name, byte numArgs) {
        OperationPtg retval = null;
        if (name.equals("IF")) {
            AttrPtg ptg = new AttrPtg();
            ptg.setData((short)6);
            ptg.setOptimizedIf(true);
            retval = ptg;
        } else {
            retval = new FuncVarPtg(name, numArgs);
        }
        return retval;
    }

    private int Arguments() {
        int numArgs = 0;
        if (this.look != ')') {
            ++numArgs;
            this.Expression();
        }
        while (this.look == ',' || this.look == ';') {
            if (this.look == ',') {
                this.Match(',');
            } else {
                this.Match(';');
            }
            this.Expression();
            ++numArgs;
        }
        return numArgs;
    }

    private void Factor() {
        if (this.look == '(') {
            this.Match('(');
            this.Expression();
            this.Match(')');
            this.tokens.add(new ParenthesisPtg());
            return;
        }
        if (this.IsAlpha(this.look)) {
            this.Ident();
        } else if (this.look == '\"') {
            this.StringLiteral();
        } else {
            String number = this.GetNum();
            if (this.look == '.') {
                this.Match('.');
                Object decimalPart = null;
                if (this.IsDigit(this.look)) {
                    number = number + "." + this.GetNum();
                }
                this.tokens.add(new NumberPtg(number));
            } else {
                this.tokens.add(new IntPtg(number));
            }
        }
    }

    private void StringLiteral() {
        this.Match('\"');
        String name = this.GetNameAsIs();
        this.Match('\"');
        this.tokens.add(new StringPtg(name));
    }

    private void Multiply() {
        this.Match('*');
        this.Factor();
        this.tokens.add(new MultiplyPtg());
    }

    private void Divide() {
        this.Match('/');
        this.Factor();
        this.tokens.add(new DividePtg());
    }

    private void Term() {
        this.Factor();
        while (this.look == '*' || this.look == '/' || this.look == '^' || this.look == '&' || this.look == '=') {
            if (this.look == '*') {
                this.Multiply();
            }
            if (this.look == '/') {
                this.Divide();
            }
            if (this.look == '^') {
                this.Power();
            }
            if (this.look == '&') {
                this.Concat();
            }
            if (this.look != '=') continue;
            this.Equal();
        }
    }

    private void Add() {
        this.Match('+');
        this.Term();
        this.tokens.add(new AddPtg());
    }

    private void Concat() {
        this.Match('&');
        this.Term();
        this.tokens.add(new ConcatPtg());
    }

    private void Equal() {
        this.Match('=');
        this.Term();
        this.tokens.add(new EqualPtg());
    }

    private void Subtract() {
        this.Match('-');
        this.Term();
        this.tokens.add(new SubtractPtg());
    }

    private void Power() {
        this.Match('^');
        this.Term();
        this.tokens.add(new PowerPtg());
    }

    private void Expression() {
        if (this.IsAddop(this.look)) {
            this.EmitLn("CLR D0");
        } else {
            this.Term();
        }
        while (this.IsAddop(this.look)) {
            if (this.look == '+') {
                this.Add();
            }
            if (this.look == '-') {
                this.Subtract();
            }
            if (this.look == '*') {
                this.Multiply();
            }
            if (this.look != '/') continue;
            this.Divide();
        }
    }

    private void init() {
        this.GetChar();
        this.SkipWhite();
    }

    public void parse() {
        List list = this.tokens;
        synchronized (list) {
            this.init();
            this.Expression();
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(FORMULA_TYPE_CELL);
    }

    public Ptg[] getRPNPtg(int formulaType) {
        Node node = this.createTree();
        this.setRootLevelRVA(node, formulaType);
        this.setParameterRVA(node, formulaType);
        return this.tokens.toArray(new Ptg[0]);
    }

    private void setRootLevelRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            } else {
                this.setClass(n, (byte)64);
            }
        } else {
            this.setClass(n, (byte)32);
        }
    }

    private void setParameterRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg) {
            int numOperands = n.getNumChildren();
            int i = 0;
            while (i < n.getNumChildren()) {
                this.setParameterRVA(n.getChild(i), ((AbstractFunctionPtg)p).getParameterClass(i), formulaType);
                if (n.getChild(i).getValue() instanceof AbstractFunctionPtg) {
                    this.setParameterRVA(n.getChild(i), formulaType);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < n.getNumChildren()) {
                this.setParameterRVA(n.getChild(i), formulaType);
                ++i;
            }
        }
    }

    private void setParameterRVA(Node n, int expectedClass, int formulaType) {
        Ptg p = n.getValue();
        if (expectedClass == 0) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            }
            if (p.getDefaultOperandClass() == 32) {
                if (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED) {
                    this.setClass(n, (byte)32);
                } else {
                    this.setClass(n, (byte)64);
                }
            }
            if (p.getDefaultOperandClass() == 64) {
                this.setClass(n, (byte)64);
            }
        } else if (expectedClass == 32) {
            if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
                this.setClass(n, (byte)64);
            } else {
                this.setClass(n, (byte)32);
            }
        } else if (p.getDefaultOperandClass() == 32 && (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED)) {
            this.setClass(n, (byte)32);
        } else {
            this.setClass(n, (byte)64);
        }
    }

    private void setClass(Node n, byte theClass) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg || !(p instanceof OperationPtg)) {
            p.setClass(theClass);
        } else {
            int i = 0;
            while (i < n.getNumChildren()) {
                this.setClass(n.getChild(i), theClass);
                ++i;
            }
        }
    }

    public static String toFormulaString(SheetReferences refs, List lptgs) {
        String retval = null;
        if (lptgs == null || lptgs.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgs = new Ptg[lptgs.size()];
        ptgs = lptgs.toArray(ptgs);
        retval = FormulaParser.toFormulaString(refs, ptgs);
        return retval;
    }

    public static String toFormulaString(SheetReferences refs, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        int numPtgs = ptgs.length;
        String result = null;
        AttrPtg ifptg = null;
        int i = 0;
        while (i < numPtgs) {
            if (ptgs[i] instanceof OperationPtg && i > 0) {
                OperationPtg o = (OperationPtg)ptgs[i];
                if (o instanceof AttrPtg && ((AttrPtg)o).isOptimizedIf()) {
                    ifptg = (AttrPtg)o;
                } else {
                    int numOperands = o.getNumberOfOperands();
                    String[] operands = new String[numOperands];
                    int j = 0;
                    while (j < numOperands) {
                        operands[numOperands - j - 1] = (String)stack.pop();
                        ++j;
                    }
                    if (o instanceof AbstractFunctionPtg && ((AbstractFunctionPtg)o).getName().equals("specialflag") && ifptg != null) {
                        result = ifptg.toFormulaString(new String[]{o.toFormulaString(operands)});
                        ifptg = null;
                    } else {
                        result = o.toFormulaString(operands);
                    }
                    stack.push(result);
                }
            } else {
                stack.push(ptgs[i].toFormulaString(refs));
            }
            ++i;
        }
        return (String)stack.pop();
    }

    private Node createTree() {
        Stack<Node> stack = new Stack<Node>();
        int numPtgs = this.tokens.size();
        int i = 0;
        while (i < numPtgs) {
            if (this.tokens.get(i) instanceof OperationPtg) {
                OperationPtg o = (OperationPtg)this.tokens.get(i);
                int numOperands = o.getNumberOfOperands();
                Node[] operands = new Node[numOperands];
                int j = 0;
                while (j < numOperands) {
                    operands[numOperands - j - 1] = (Node)stack.pop();
                    ++j;
                }
                Node result = new Node(o);
                result.setChildren(operands);
                stack.push(result);
            } else {
                stack.push(new Node((Ptg)this.tokens.get(i)));
            }
            ++i;
        }
        return (Node)stack.pop();
    }

    public String toString() {
        SheetReferences refs = this.book.getSheetReferences();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            buf.append(((Ptg)this.tokens.get(i)).toFormulaString(refs));
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }
}

