/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.hpsf.Util;
import org.apache.poi.util.LittleEndian;

public class TypeReader {
    public static Object read(byte[] src, int offset, int length, int type) {
        Object value;
        length -= 4;
        switch (type) {
            case 2: {
                value = new Integer(LittleEndian.getUShort(src, offset));
                break;
            }
            case 3: {
                value = new Long(LittleEndian.getUInt(src, offset));
                break;
            }
            case 64: {
                long low = LittleEndian.getUInt(src, offset);
                long high = LittleEndian.getUInt(src, offset += 4);
                value = Util.filetimeToDate((int)high, (int)low);
                break;
            }
            case 30: {
                int first = offset + 4;
                long last = (long)first + LittleEndian.getUInt(src, offset) - 1L;
                offset += 4;
                while (src[(int)last] == 0 && (long)first <= last) {
                    --last;
                }
                value = new String(src, first, (int)(last - (long)first + 1L));
                break;
            }
            case 31: {
                int first = offset + 4;
                long last = (long)first + LittleEndian.getUInt(src, offset) - 1L;
                long l = last - (long)first;
                offset += 4;
                StringBuffer b = new StringBuffer((int)(last - (long)first));
                int i = 0;
                while ((long)i <= l) {
                    int i1 = offset + i * 2;
                    int i2 = i1 + 1;
                    b.append((char)((src[i2] << 8) + src[i1]));
                    ++i;
                }
                while (b.charAt(b.length() - 1) == '\u0000') {
                    b.setLength(b.length() - 1);
                }
                value = b.toString();
                break;
            }
            case 71: {
                byte[] v = new byte[length];
                int i = 0;
                while (i < length) {
                    v[i] = src[offset + i];
                    ++i;
                }
                value = v;
                break;
            }
            case 11: {
                int first = offset + 4;
                long bool = LittleEndian.getUInt(src, offset);
                if (bool != 0L) {
                    value = new Boolean(true);
                    break;
                }
                value = new Boolean(false);
                break;
            }
            default: {
                byte[] v = new byte[length];
                int i = 0;
                while (i < length) {
                    v[i] = src[offset + i];
                    ++i;
                }
                value = v;
                break;
            }
        }
        return value;
    }
}

