/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MapHandler;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.handlers.MapHandlers;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.List;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.MimeBase64Encoder;
import org.exolab.castor.util.NestedIOException;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.ClassDescriptorEnumeration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.MarshalListener;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.ProcessingInstruction;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.descriptors.RootArrayDescriptor;
import org.exolab.castor.xml.descriptors.StringClassDescriptor;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.handlers.EnumFieldHandler;
import org.exolab.castor.xml.util.AnyNode2SAX;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.SAX2DOMHandler;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.ParserAdapter;

public class Marshaller
extends MarshalFramework {
    private static final String CDATA = "CDATA";
    private static final String DEFAULT_PREFIX = "ns";
    private static final String SERIALIZER_NOT_SAX_CAPABLE = "conf.serializerNotSaxCapable";
    private static final String XMLNS = "xmlns";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_TYPE = "xsi:type";
    private int NAMESPACE_COUNTER = 0;
    private static final StringClassDescriptor _StringClassDescriptor = new StringClassDescriptor();
    public static boolean enableDebug = false;
    private boolean _asDocument = true;
    private ClassDescriptorResolver _cdResolver = null;
    private boolean _debug = false;
    int depth = 0;
    private OutputFormat _format = null;
    private DocumentHandler _handler = null;
    private PrintWriter _logWriter = null;
    private Configuration _config = null;
    private boolean _marshalExtendedType = true;
    private MarshalListener _marshalListener = null;
    private Namespaces _namespaces = null;
    private XMLNaming _naming = null;
    private Node _node = null;
    private List _packages = null;
    private Stack _parents = null;
    private List _processingInstructions = null;
    private String _rootElement = null;
    private Serializer _serializer = null;
    private boolean _suppressXSIType = false;
    private AttributeSetImpl _topLevelAtts = null;
    private AttributeListImpl _attributes = null;
    private boolean _validate = false;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$XMLClassDescriptorImpl;

    public Marshaller(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        this._handler = handler;
        this.initialize();
    }

    public Marshaller(ContentHandler handler) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        if (handler instanceof DocumentHandler) {
            this._handler = (DocumentHandler)((Object)handler);
        } else {
            try {
                ParserAdapter adapter = new ParserAdapter();
                adapter.setContentHandler(handler);
                this._handler = adapter;
            }
            catch (SAXException sx) {
                throw new NestedIOException(sx);
            }
        }
        this.initialize();
    }

    public Marshaller(Writer out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument 'out' is null.");
        }
        this.initialize();
        this._serializer = this._config.getSerializer();
        if (this._serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        this._serializer.setOutputCharStream(out);
        this._handler = this._serializer.asDocumentHandler();
        if (this._handler == null) {
            String err = Messages.format(SERIALIZER_NOT_SAX_CAPABLE, this._serializer.getClass().getName());
            throw new RuntimeException(err);
        }
    }

    public Marshaller(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 'node' is null.");
        }
        this._node = node;
        this._handler = new SAX2DOMHandler(node);
        this.initialize();
    }

    private void initialize() {
        this._config = LocalConfiguration.getInstance();
        this._debug = enableDebug;
        this._namespaces = new Namespaces();
        this._packages = new List(3);
        this._cdResolver = new ClassDescriptorResolverImpl();
        this._parents = new Stack();
        this._validate = this._config.marshallingValidation();
        this._naming = XMLNaming.getInstance();
        this._processingInstructions = new List(3);
        this._attributes = new AttributeListImpl();
        this._topLevelAtts = new AttributeSetImpl();
    }

    public void addProcessingInstruction(String target, String data) {
        if (target == null || target.length() == 0) {
            String err = "the argument 'target' must not be null or empty.";
            throw new IllegalArgumentException(err);
        }
        if (data == null) {
            String err = "the argument 'data' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._processingInstructions.add(new ProcessingInstruction(target, data));
    }

    public void setDoctype(String publicId, String systemId) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this._config.getOutputFormat();
            }
            this._format.setDoctype(publicId, systemId);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = this._serializer.asDocumentHandler();
            }
            catch (IOException iox) {}
        } else {
            String error = "doctype cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
    }

    public void setMarshalAsDocument(boolean asDocument) {
        this._asDocument = asDocument;
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this._config.getOutputFormat();
            }
            this._format.setOmitXMLDeclaration(!asDocument);
            this._format.setOmitDocumentType(!asDocument);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = this._serializer.asDocumentHandler();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl();
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setMarshalListener(MarshalListener listener) {
        this._marshalListener = listener;
    }

    public void setNamespaceMapping(String nsPrefix, String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            String err = "namespace URI must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._namespaces.addNamespace(nsPrefix, nsURI);
    }

    public void setRootElement(String rootElement) {
        this._rootElement = rootElement;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public void setNSPrefixAtRoot(boolean nsPrefixAtRoot) {
    }

    public boolean getNSPrefixAtRoot() {
        return true;
    }

    public void setResolver(ClassDescriptorResolver cdr) {
        if (cdr != null) {
            this._cdResolver = cdr;
        }
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setMarshalExtendedType(boolean marshalExtendedType) {
        this._marshalExtendedType = marshalExtendedType;
    }

    public boolean getMarshalExtendedType() {
        return this._marshalExtendedType;
    }

    public static void marshal(Object object, Writer out) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, Writer)");
        }
        try {
            Marshaller marshaller = new Marshaller(out);
            marshaller.marshal(object);
        }
        catch (IOException except) {
            throw new MarshalException(except);
        }
    }

    public static void marshal(Object object, DocumentHandler handler) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, DocumentHandler)");
        }
        Marshaller marshaller = new Marshaller(handler);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, ContentHandler handler) throws MarshalException, ValidationException, IOException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, DocumentHandler)");
        }
        Marshaller marshaller = new Marshaller(handler);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, Node node) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (enableDebug) {
            System.out.print("- Marshaller called using ");
            System.out.println("*static* marshal(Object, Node)");
        }
        Marshaller marshaller = new Marshaller(node);
        marshaller.marshal(object);
    }

    public void marshal(Object object) throws MarshalException, ValidationException {
        if (object == null) {
            throw new MarshalException("object must not be null");
        }
        if (this._debug) {
            System.out.println("Marshalling " + object.getClass().getName());
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX.fireEvents((AnyNode)object, this._handler, this._namespaces);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
        } else {
            this.validate(object);
            if (this._asDocument) {
                try {
                    this._handler.startDocument();
                    for (int i = 0; i < this._processingInstructions.size(); ++i) {
                        ProcessingInstruction pi = (ProcessingInstruction)this._processingInstructions.get(i);
                        this._handler.processingInstruction(pi.getTarget(), pi.getData());
                    }
                    this.marshal(object, null, this._handler);
                    this._handler.endDocument();
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            } else {
                this.marshal(object, null, this._handler);
            }
        }
    }

    private void marshal(Object object, XMLFieldDescriptor descriptor, DocumentHandler handler) throws MarshalException, ValidationException {
        char[] chars;
        String valueType;
        String defaultNamespace;
        String nsURI;
        String nsPrefix;
        if (object == null) {
            String err = "Marshaller#marshal: null parameter: 'object'";
            throw new MarshalException(err);
        }
        if (descriptor != null && descriptor.isTransient()) {
            return;
        }
        if (this._marshalListener != null && !this._marshalListener.preMarshal(object)) {
            return;
        }
        if (object instanceof AnyNode) {
            try {
                AnyNode2SAX.fireEvents((AnyNode)object, handler, this._namespaces);
            }
            catch (SAXException e) {
                throw new MarshalException(e);
            }
            return;
        }
        boolean containerField = false;
        if (descriptor != null && descriptor.isContainer()) {
            containerField = true;
        }
        if (this._parents.search(object) >= 0) {
            return;
        }
        this._parents.push(object);
        Class _class = object.getClass();
        boolean byteArray = false;
        if (_class.isArray()) {
            byteArray = _class.getComponentType() == Byte.TYPE;
        }
        boolean atRoot = false;
        if (descriptor == null) {
            descriptor = new XMLFieldDescriptorImpl(_class, "root", null, null);
            atRoot = true;
        }
        String name = descriptor.getXMLName();
        if (atRoot && this._rootElement != null) {
            name = this._rootElement;
        }
        boolean autoNameByClass = false;
        if (name == null) {
            autoNameByClass = true;
            name = _class.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            name = this._naming.toXMLName(name);
        }
        XMLClassDescriptor classDesc = null;
        boolean saveType = false;
        if (_class == descriptor.getFieldType()) {
            classDesc = (XMLClassDescriptor)descriptor.getClassDescriptor();
        }
        if (classDesc == null) {
            if (Marshaller.isPrimitive(_class) || byteArray) {
                classDesc = _StringClassDescriptor;
                Class<?> fieldType = descriptor.getFieldType();
                if (_class != fieldType) {
                    while (fieldType.isArray()) {
                        fieldType = fieldType.getComponentType();
                    }
                    saveType = !Marshaller.primitiveOrWrapperEquals(_class, fieldType);
                }
            } else {
                String pkgName;
                saveType = _class.isArray();
                String className = _class.getName();
                int idx = className.lastIndexOf(".");
                if (idx > 0 && !this._packages.contains(pkgName = className.substring(0, idx + 1))) {
                    this._packages.add(pkgName);
                }
                if (this._marshalExtendedType) {
                    classDesc = this.getClassDescriptor(_class);
                    if (_class != descriptor.getFieldType() && classDesc != null) {
                        XMLClassDescriptor tmpCDesc;
                        String nsURI2 = classDesc.getNameSpaceURI();
                        String tmpName = name;
                        if (autoNameByClass && classDesc.getXMLName() != null) {
                            tmpName = classDesc.getXMLName();
                        }
                        saveType = (tmpCDesc = this._cdResolver.resolveByXMLName(tmpName, nsURI2, null)) != null ? tmpCDesc.getClass() != classDesc.getClass() : true;
                    }
                } else {
                    _class = descriptor.getFieldType();
                    classDesc = this.getClassDescriptor(_class);
                }
                if (classDesc == null && _class.isArray()) {
                    classDesc = new RootArrayDescriptor(_class);
                    if (atRoot) {
                        boolean bl = containerField = !this._asDocument;
                    }
                }
                if (atRoot && this._rootElement != null) {
                    name = this._rootElement;
                } else if (descriptor.getXMLName() == null && classDesc != null) {
                    name = classDesc.getXMLName();
                }
            }
            if (classDesc == null) {
                if (_class == (class$java$lang$Void == null ? (class$java$lang$Void = Marshaller.class$("java.lang.Void")) : class$java$lang$Void) || _class == (class$java$lang$Object == null ? (class$java$lang$Object = Marshaller.class$("java.lang.Object")) : class$java$lang$Object) || _class == (class$java$lang$Class == null ? (class$java$lang$Class = Marshaller.class$("java.lang.Class")) : class$java$lang$Class)) {
                    throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
                }
                this._parents.pop();
                return;
            }
        }
        if (autoNameByClass && classDesc.getXMLName() != null) {
            name = classDesc.getXMLName();
        }
        boolean bl = saveType = saveType && !this._suppressXSIType;
        if (saveType) {
            if (descriptor.getHandler() instanceof DateFieldHandler) {
                saveType = false;
            } else if (descriptor.getHandler() instanceof EnumFieldHandler) {
                saveType = false;
            }
        }
        if (saveType) {
            String xmlElementName = name;
            XMLClassDescriptor xmlElementNameClassDesc = this._cdResolver.resolveByXMLName(xmlElementName, null, null);
            if (xmlElementName != null && xmlElementNameClassDesc != null) {
                XMLClassDescriptor tempContaining;
                ClassDescriptorEnumeration cdEnum = this._cdResolver.resolveAllByXMLName(xmlElementName, null, null);
                while (cdEnum.hasNext() && _class != (xmlElementNameClassDesc = cdEnum.getNext()).getJavaClass()) {
                    xmlElementNameClassDesc = null;
                }
                if (xmlElementNameClassDesc instanceof XMLClassDescriptorAdapter && (tempContaining = (XMLClassDescriptor)descriptor.getContainingClassDescriptor()) != null) {
                    XMLFieldDescriptor fieldDescMatch = tempContaining.getFieldDescriptor(xmlElementName, NodeType.Element);
                    MarshalFramework.InheritanceMatch[] matches = Marshaller.searchInheritance(xmlElementName, null, tempContaining, this._cdResolver);
                    if (matches.length == 1) {
                        boolean oneAndOnlyOneMatchedField;
                        boolean foundTheRightClass = xmlElementNameClassDesc != null && _class == xmlElementNameClassDesc.getJavaClass();
                        boolean bl2 = oneAndOnlyOneMatchedField = fieldDescMatch != null || matches[0].parentFieldDesc == descriptor;
                        if (foundTheRightClass && oneAndOnlyOneMatchedField) {
                            saveType = false;
                        }
                    }
                }
            }
        }
        if (!atRoot) {
            this._namespaces = this._namespaces.createNamespaces();
        }
        if ((nsPrefix = descriptor.getNameSpacePrefix()) == null) {
            nsPrefix = classDesc.getNameSpacePrefix();
        }
        if ((nsURI = descriptor.getNameSpaceURI()) == null) {
            nsURI = classDesc.getNameSpaceURI();
        }
        if (nsURI == null && nsPrefix != null) {
            nsURI = this._namespaces.getNamespaceURI(nsPrefix);
        } else if (nsPrefix == null && nsURI != null) {
            nsPrefix = this._namespaces.getNamespacePrefix(nsURI);
        }
        if (nsURI != null) {
            defaultNamespace = this._namespaces.getNamespaceURI("");
            if (nsPrefix == null && !nsURI.equals(defaultNamespace)) {
                nsPrefix = defaultNamespace == null && atRoot ? "" : DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
            }
            this.declareNamespace(nsPrefix, nsURI);
        } else {
            defaultNamespace = this._namespaces.getNamespaceURI("");
            if (defaultNamespace != null && !"".equals(defaultNamespace)) {
                this._namespaces.addNamespace("", "");
            }
        }
        AttributeListImpl atts = new AttributeListImpl();
        if (atRoot) {
            if (this._topLevelAtts.getSize() > 0) {
                this._namespaces.addNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            }
            for (int i = 0; i < this._topLevelAtts.getSize(); ++i) {
                String attName = this._topLevelAtts.getName(i);
                String ns = this._topLevelAtts.getNamespace(i);
                String prefix = null;
                if (ns != null && ns.length() > 0) {
                    prefix = this._namespaces.getNonDefaultNamespacePrefix(ns);
                }
                if (prefix != null && prefix.length() > 0) {
                    attName = prefix + ':' + attName;
                }
                atts.addAttribute(attName, CDATA, this._topLevelAtts.getValue(i));
            }
        }
        int nestedAttCount = 0;
        XMLFieldDescriptor[] nestedAtts = null;
        XMLFieldDescriptor[] descriptors = null;
        descriptors = !descriptor.isReference() ? classDesc.getAttributeDescriptors() : new XMLFieldDescriptor[]{};
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] == null) continue;
            String path = descriptors[i].getLocationPath();
            if (path != null && path.length() > 0) {
                if (nestedAtts == null) {
                    nestedAtts = new XMLFieldDescriptor[descriptors.length - i];
                }
                nestedAtts[nestedAttCount++] = descriptors[i];
                continue;
            }
            this.processAttribute(object, descriptors[i], atts);
        }
        this.processContainerAttributes(object, classDesc, atts);
        if (saveType) {
            this.declareNamespace(XSI_PREFIX, "http://www.w3.org/2001/XMLSchema-instance");
            String typeName = classDesc.getXMLName();
            boolean introspected = false;
            introspected = classDesc instanceof MarshalFramework.InternalXMLClassDescriptor ? ((MarshalFramework.InternalXMLClassDescriptor)classDesc).introspected() : Introspector.introspected(classDesc);
            if (typeName == null || introspected) {
                typeName = "java:" + _class.getName();
            } else if (classDesc instanceof RootArrayDescriptor) {
                typeName = "java:" + _class.getName();
            } else {
                String dcn = classDesc.getClass().getName();
                if (dcn.equals((class$org$exolab$castor$xml$util$XMLClassDescriptorImpl == null ? (class$org$exolab$castor$xml$util$XMLClassDescriptorImpl = Marshaller.class$("org.exolab.castor.xml.util.XMLClassDescriptorImpl")) : class$org$exolab$castor$xml$util$XMLClassDescriptorImpl).getName())) {
                    typeName = "java:" + _class.getName();
                } else {
                    String tns = classDesc.getNameSpaceURI();
                    String prefix = null;
                    if (tns != null && tns.length() > 0 && (prefix = this._namespaces.getNamespacePrefix(tns)) != null && prefix.length() > 0) {
                        typeName = prefix + ':' + typeName;
                    }
                }
            }
            atts.addAttribute(XSI_TYPE, CDATA, typeName);
        }
        if ((valueType = descriptor.getSchemaType()) != null && valueType.equals("QName")) {
            object = this.resolveQName(object, descriptor);
        }
        this._namespaces.declareAsAttributes(atts, true);
        String qName = null;
        if (nsPrefix != null) {
            int len = nsPrefix.length();
            if (len > 0) {
                StringBuffer sb = new StringBuffer(len + name.length() + 1);
                sb.append(nsPrefix);
                sb.append(':');
                sb.append(name);
                qName = sb.toString();
            } else {
                qName = name;
            }
        } else {
            qName = name;
        }
        try {
            if (!containerField) {
                handler.startElement(qName, atts);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        XMLFieldDescriptor cdesc = null;
        if (!descriptor.isReference()) {
            cdesc = classDesc.getContentDescriptor();
        }
        if (cdesc != null) {
            Object obj = null;
            try {
                obj = cdesc.getHandler().getValue(object);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            if (obj != null) {
                chars = null;
                Class<?> objType = obj.getClass();
                if (objType.isArray() && objType.getComponentType() == Byte.TYPE) {
                    MimeBase64Encoder encoder = new MimeBase64Encoder();
                    encoder.translate((byte[])obj);
                    chars = encoder.getCharArray();
                } else {
                    String str = obj.toString();
                    if (str != null && str.length() > 0) {
                        chars = str.toCharArray();
                    }
                }
                if (chars != null && chars.length > 0) {
                    try {
                        handler.characters(chars, 0, chars.length);
                    }
                    catch (SAXException sx) {
                        throw new MarshalException(sx);
                    }
                }
            }
        } else if (descriptor.isReference()) {
            Object id = this.getObjectID(object);
            if (id != null) {
                chars = id.toString().toCharArray();
                try {
                    handler.characters(chars, 0, chars.length);
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
        } else {
            if (byteArray) {
                MimeBase64Encoder encoder = new MimeBase64Encoder();
                encoder.translate((byte[])object);
                chars = encoder.getCharArray();
                try {
                    handler.characters(chars, 0, chars.length);
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (Marshaller.isPrimitive(_class)) {
                char[] chars2 = object.toString().toCharArray();
                try {
                    handler.characters(chars2, 0, chars2.length);
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
        }
        descriptors = classDesc.getElementDescriptors();
        if (descriptor.isReference()) {
            descriptors = new XMLFieldDescriptor[]{};
        }
        ++this.depth;
        Stack wrappers = null;
        for (int i = 0; i < descriptors.length; ++i) {
            Class<?> type;
            XMLFieldDescriptor elemDescriptor = descriptors[i];
            Object obj = null;
            try {
                obj = elemDescriptor.getHandler().getValue(object);
            }
            catch (IllegalStateException ise) {
                continue;
            }
            if (obj == null) continue;
            String path = elemDescriptor.getLocationPath();
            String currentLoc = null;
            if (wrappers != null) {
                try {
                    while (!wrappers.empty()) {
                        WrapperInfo wInfo = (WrapperInfo)wrappers.peek();
                        if (path != null) {
                            if (wInfo.location.equals(path)) {
                                path = null;
                                break;
                            }
                            if (path.startsWith(wInfo.location + "/")) {
                                path = path.substring(wInfo.location.length() + 1);
                                currentLoc = wInfo.location;
                                break;
                            }
                        }
                        handler.endElement(wInfo.qName);
                        wrappers.pop();
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if (path != null) {
                this._attributes.clear();
                if (wrappers == null) {
                    wrappers = new Stack();
                }
                try {
                    while (path != null) {
                        String elemName = null;
                        int idx = path.indexOf(47);
                        if (idx > 0) {
                            elemName = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName : currentLoc + "/" + elemName;
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            elemName = nsPrefix + ':' + elemName;
                        }
                        wrappers.push(new WrapperInfo(elemName, currentLoc));
                        this._attributes.clear();
                        if (nestedAttCount > 0) {
                            for (int na = 0; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(elemName, this._attributes);
                    }
                }
                catch (SAXException sx) {
                    throw new MarshalException(sx);
                }
            }
            if ((type = obj.getClass()).isArray() && type.getComponentType() == Byte.TYPE) {
                this.marshal(obj, elemDescriptor, handler);
                continue;
            }
            if (Marshaller.isCollection(type)) {
                CollectionHandler colHandler = this.getCollectionHandler(type);
                Enumeration enumeration = colHandler.elements(obj);
                while (enumeration.hasMoreElements()) {
                    Object item = enumeration.nextElement();
                    if (item == null) continue;
                    this.marshal(item, elemDescriptor, handler);
                }
                continue;
            }
            this.marshal(obj, elemDescriptor, handler);
        }
        if (wrappers != null) {
            try {
                while (!wrappers.empty()) {
                    WrapperInfo wInfo = (WrapperInfo)wrappers.pop();
                    handler.endElement(wInfo.qName);
                }
            }
            catch (SAXException sx) {
                throw new MarshalException(sx);
            }
        }
        if (nestedAttCount > 0) {
            if (wrappers == null) {
                wrappers = new Stack();
            }
            for (int i = 0; i < nestedAtts.length; ++i) {
                if (nestedAtts[i] == null) continue;
                String path = nestedAtts[i].getLocationPath();
                if (nestedAtts[i].getHandler().getValue(object) == null) {
                    nestedAtts[i] = null;
                    --nestedAttCount;
                    continue;
                }
                String currentLoc = null;
                try {
                    while (path != null) {
                        int idx = path.indexOf(47);
                        String elemName = null;
                        if (idx > 0) {
                            elemName = path.substring(0, idx);
                            path = path.substring(idx + 1);
                        } else {
                            elemName = path;
                            path = null;
                        }
                        currentLoc = currentLoc == null ? elemName : currentLoc + "/" + elemName;
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            elemName = nsPrefix + ':' + elemName;
                        }
                        wrappers.push(elemName);
                        this._attributes.clear();
                        if (path == null) {
                            this.processAttribute(object, nestedAtts[i], this._attributes);
                            nestedAtts[i] = null;
                            --nestedAttCount;
                        }
                        if (nestedAttCount > 0) {
                            for (int na = i + 1; na < nestedAtts.length; ++na) {
                                String tmpPath;
                                if (nestedAtts[na] == null || !(tmpPath = nestedAtts[na].getLocationPath()).equals(currentLoc)) continue;
                                this.processAttribute(object, nestedAtts[na], this._attributes);
                                nestedAtts[na] = null;
                                --nestedAttCount;
                            }
                        }
                        handler.startElement(elemName, this._attributes);
                    }
                    while (!wrappers.empty()) {
                        handler.endElement((String)wrappers.pop());
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new MarshalException(e);
                }
            }
        }
        try {
            if (!containerField) {
                handler.endElement(qName);
            }
        }
        catch (SAXException sx) {
            throw new MarshalException(sx);
        }
        --this.depth;
        this._parents.pop();
        if (!atRoot) {
            this._namespaces = this._namespaces.getParent();
        }
        if (this._marshalListener != null) {
            this._marshalListener.postMarshal(object);
        }
    }

    private Object getObjectID(Object object) throws MarshalException {
        if (object == null) {
            return null;
        }
        Object id = null;
        XMLClassDescriptor cd = this.getClassDescriptor(object.getClass());
        String err = null;
        if (cd != null) {
            XMLFieldDescriptor fieldDesc = (XMLFieldDescriptor)cd.getIdentity();
            if (fieldDesc != null) {
                FieldHandler fieldHandler = fieldDesc.getHandler();
                if (fieldHandler != null) {
                    try {
                        id = fieldHandler.getValue(object);
                    }
                    catch (IllegalStateException ise) {
                        err = ise.toString();
                    }
                } else {
                    err = "FieldHandler for Identity descriptor is null.";
                }
            } else {
                err = "No identity descriptor available";
            }
        } else {
            err = "Unable to resolve ClassDescriptor.";
        }
        if (err != null) {
            String errMsg = "Unable to resolve ID for instance of class '";
            errMsg = errMsg + object.getClass().getName();
            errMsg = errMsg + "' due to the following error: ";
            throw new MarshalException(errMsg + err);
        }
        return id;
    }

    private boolean declareNamespace(String nsPrefix, String nsURI) {
        boolean declared = false;
        if (nsURI != null && nsURI.length() != 0) {
            String tmpURI = this._namespaces.getNamespaceURI(nsPrefix);
            if (tmpURI != null && tmpURI.equals(nsURI)) {
                return declared;
            }
            String tmpPrefix = this._namespaces.getNamespacePrefix(nsURI);
            if (tmpPrefix == null || !tmpPrefix.equals(nsPrefix)) {
                this._namespaces.addNamespace(nsPrefix, nsURI);
                declared = true;
            }
        }
        return declared;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public void setEncoding(String encoding) {
        if (this._serializer != null) {
            if (this._format == null) {
                this._format = this._config.getOutputFormat();
            }
            this._format.setEncoding(encoding);
            this._serializer.setOutputFormat(this._format);
            try {
                this._handler = this._serializer.asDocumentHandler();
            }
            catch (IOException iox) {}
        } else {
            String error = "encoding cannot be set if you've passed in your own DocumentHandler";
            throw new IllegalStateException(error);
        }
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("noNamespaceSchemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSchemaLocation(String schemaLocation) {
        if (schemaLocation != null) {
            this._topLevelAtts.setAttribute("schemaLocation", schemaLocation, "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public void setSuppressXSIType(boolean suppressXSIType) {
        this._suppressXSIType = suppressXSIType;
    }

    private XMLClassDescriptor getClassDescriptor(Class _class) throws MarshalException {
        XMLClassDescriptor classDesc = null;
        if (!Marshaller.isPrimitive(_class)) {
            classDesc = this._cdResolver.resolve(_class);
        }
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        if (classDesc != null) {
            classDesc = new MarshalFramework.InternalXMLClassDescriptor(classDesc);
        }
        return classDesc;
    }

    private XMLClassDescriptor getClassDescriptor(String className, ClassLoader loader) throws MarshalException {
        XMLClassDescriptor classDesc = this._cdResolver.resolve(className, loader);
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        if (classDesc != null) {
            classDesc = new MarshalFramework.InternalXMLClassDescriptor(classDesc);
        }
        return classDesc;
    }

    private void processAttribute(Object object, XMLFieldDescriptor attDescriptor, AttributeListImpl atts) throws MarshalException {
        if (attDescriptor == null) {
            return;
        }
        if (attDescriptor.getNodeType() == NodeType.Namespace) {
            Object map = attDescriptor.getHandler().getValue(object);
            MapHandler mapHandler = MapHandlers.getHandler(map);
            if (mapHandler != null) {
                Enumeration keys = mapHandler.keys(map);
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object val = mapHandler.get(map, key);
                    this.declareNamespace(key.toString(), val.toString());
                }
            }
            return;
        }
        String xmlName = attDescriptor.getXMLName();
        String namespace = attDescriptor.getNameSpaceURI();
        if (namespace != null && namespace.length() > 0) {
            String prefix = attDescriptor.getNameSpacePrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = this._namespaces.getNonDefaultNamespacePrefix(namespace);
            }
            if (prefix == null || prefix.length() == 0) {
                prefix = DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
            }
            this.declareNamespace(prefix, namespace);
            xmlName = prefix + ':' + xmlName;
        }
        Object value = null;
        try {
            value = attDescriptor.getHandler().getValue(object);
        }
        catch (IllegalStateException ise) {
            return;
        }
        if (attDescriptor.isReference() && value != null) {
            if (attDescriptor.isMultivalued()) {
                Enumeration enumeration = null;
                if (value instanceof Enumeration) {
                    enumeration = (Enumeration)value;
                } else {
                    CollectionHandler colHandler = null;
                    try {
                        colHandler = CollectionHandlers.getHandler(value.getClass());
                    }
                    catch (MappingException mx) {
                        throw new MarshalException(mx);
                    }
                    enumeration = colHandler.elements(value);
                }
                if (enumeration.hasMoreElements()) {
                    StringBuffer sb = new StringBuffer();
                    int v = 0;
                    while (enumeration.hasMoreElements()) {
                        if (v > 0) {
                            sb.append(' ');
                        }
                        sb.append(this.getObjectID(enumeration.nextElement()).toString());
                        ++v;
                    }
                    value = sb;
                } else {
                    value = null;
                }
            } else {
                value = this.getObjectID(value);
            }
        }
        if (value != null) {
            String valueType = attDescriptor.getSchemaType();
            if (valueType != null && valueType.equals("QName")) {
                value = this.resolveQName(value, attDescriptor);
            }
            atts.addAttribute(xmlName, CDATA, value.toString());
        }
    }

    private void processContainerAttributes(Object target, XMLClassDescriptor classDesc, AttributeListImpl atts) throws MarshalException {
        if (classDesc instanceof XMLClassDescriptorImpl && !((XMLClassDescriptorImpl)classDesc).hasContainerFields()) {
            return;
        }
        XMLFieldDescriptor[] elemDescriptors = classDesc.getElementDescriptors();
        for (int i = 0; i < elemDescriptors.length; ++i) {
            if (elemDescriptors[i] == null || !elemDescriptors[i].isContainer()) continue;
            this.processContainerAttributes(target, elemDescriptors[i], atts);
        }
    }

    private void processContainerAttributes(Object target, XMLFieldDescriptor containerFieldDesc, AttributeListImpl atts) throws MarshalException {
        if (target.getClass().isArray()) {
            int length = Array.getLength(target);
            for (int j = 0; j < length; ++j) {
                Object item = Array.get(target, j);
                if (item == null) continue;
                this.processContainerAttributes(item, containerFieldDesc, atts);
            }
            return;
        }
        Object containerObject = containerFieldDesc.getHandler().getValue(target);
        if (containerObject == null) {
            return;
        }
        XMLClassDescriptor containerClassDesc = (XMLClassDescriptor)containerFieldDesc.getClassDescriptor();
        if (containerClassDesc == null && (containerClassDesc = this.getClassDescriptor(containerFieldDesc.getFieldType())) == null) {
            return;
        }
        XMLFieldDescriptor[] attrDescriptors = containerClassDesc.getAttributeDescriptors();
        for (int idx = 0; idx < attrDescriptors.length; ++idx) {
            if (attrDescriptors[idx] == null) continue;
            this.processAttribute(containerObject, attrDescriptors[idx], atts);
        }
        this.processContainerAttributes(containerObject, containerClassDesc, atts);
    }

    private Object resolveQName(Object value, XMLFieldDescriptor fieldDesc) {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        if (!(fieldDesc instanceof XMLFieldDescriptorImpl)) {
            return value;
        }
        String result = (String)value;
        String nsURI = null;
        int idx = -1;
        if (result.length() > 0 && result.charAt(0) == '{') {
            idx = result.indexOf(125);
            if (idx <= 0) {
                String err = "Bad QName value :'" + result + "', it should follow the pattern '{URI}value'";
                throw new IllegalArgumentException(err);
            }
        } else {
            return value;
        }
        nsURI = result.substring(1, idx);
        String prefix = ((XMLFieldDescriptorImpl)fieldDesc).getQNamePrefix();
        if (prefix == null) {
            prefix = this._namespaces.getNamespacePrefix(nsURI);
        }
        if (prefix == null) {
            prefix = DEFAULT_PREFIX + ++this.NAMESPACE_COUNTER;
        }
        result = prefix.length() != 0 ? prefix + ":" + result.substring(idx + 1) : result.substring(idx + 1);
        this.declareNamespace(prefix, nsURI);
        return result;
    }

    private void validate(Object object) throws ValidationException {
        if (this._validate) {
            Validator validator = new Validator();
            ValidationContext context = new ValidationContext();
            context.setConfiguration(this._config);
            context.setResolver(this._cdResolver);
            validator.validate(object, context);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class WrapperInfo {
        String qName = null;
        String location = null;

        WrapperInfo(String qName, String location) {
            this.qName = qName;
            this.location = location;
        }
    }
}

