/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.URLUtil;
import org.apache.webdav.lib.WebdavState;

public class UnlockMethod
extends HttpMethodBase {
    private String lockToken = null;

    public UnlockMethod() {
    }

    public UnlockMethod(String path) {
        super(path);
    }

    public UnlockMethod(String path, String lockToken) {
        this(path);
        this.setLockToken(lockToken);
    }

    public void setLockToken(String lockToken) {
        this.checkNotUsed();
        this.lockToken = lockToken;
    }

    public String getName() {
        return "UNLOCK";
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Lock-Token")) {
            this.setLockToken(headerValue);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        super.setRequestHeader("Lock-Token", "<" + this.lockToken + ">");
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
        if (this.getStatusLine().getStatusCode() == 204 && state instanceof WebdavState) {
            ((WebdavState)state).removeLock(this.getPath(), this.lockToken);
        }
    }

    public void setPath(String path) {
        this.setPath(path, null);
    }

    public void setPath(String path, String enc) {
        if (enc == null) {
            enc = "UTF-8";
        }
        super.setPath(URLUtil.URLEncode(path, enc));
    }
}

