/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.URLUtil;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MoveMethod
extends XMLResponseMethodBase {
    private String destination;
    private boolean overwrite = true;

    public MoveMethod() {
    }

    public MoveMethod(String source) {
        super(source);
    }

    public MoveMethod(String source, String destination) {
        this(source);
        this.setDestination(destination);
    }

    public MoveMethod(String source, String destination, boolean overwrite) {
        this(source, destination);
        this.setOverwrite(overwrite);
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Overwrite")) {
            this.setOverwrite(!headerValue.equalsIgnoreCase("F") && !headerValue.equalsIgnoreCase("False"));
        } else if (headerName.equalsIgnoreCase("Destination")) {
            this.setDestination(headerValue);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setDestination(String destination) {
        this.checkNotUsed();
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setOverwrite(boolean overwrite) {
        this.checkNotUsed();
        this.overwrite = overwrite;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String getName() {
        return "MOVE";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        String absoluteDestination = conn.getProtocol().getScheme() + "://" + conn.getHost() + ":" + conn.getPort() + URLUtil.URLEncode(this.destination, "utf-8");
        super.setRequestHeader("Destination", absoluteDestination);
        if (!this.isOverwrite()) {
            super.setRequestHeader("Overwrite", "F");
        }
    }
}

