/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.URLUtil;

public abstract class HttpRequestBodyMethodBase
extends HttpMethodBase {
    private byte[] data = null;
    private File file = null;
    private URL url = null;

    public HttpRequestBodyMethodBase() {
    }

    public HttpRequestBodyMethodBase(String path) {
        super(URLUtil.URLEncode(path, "UTF-8"));
    }

    public void setRequestBody(File file) throws IOException {
        this.checkNotUsed();
        this.file = file;
    }

    public void setRequestBody(URL url) throws IOException {
        this.checkNotUsed();
        this.url = url;
    }

    public void setRequestBody(byte[] bodydata) {
        this.checkNotUsed();
        this.data = bodydata;
    }

    public void setRequestBody(String bodydata) {
        this.checkNotUsed();
        this.setRequestBody(HttpConstants.getContentBytes((String)bodydata, (String)this.getRequestCharSet()));
    }

    public void setRequestBody(InputStream is) throws IOException {
        this.checkNotUsed();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int nb = 0;
        while ((nb = is.read(buffer)) != -1) {
            os.write(buffer, 0, nb);
        }
        this.data = os.toByteArray();
    }

    public boolean readContinueCode() {
        if (this.getStatusLine() == null) {
            return false;
        }
        return null == this.getRequestHeader("expect") || this.getStatusLine().getStatusCode() == 100;
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        OutputStream out = conn.getRequestOutputStream();
        if (this.isHttp11() && null == this.getRequestHeader("Content-Length")) {
            out = new ChunkedOutputStream(out);
        }
        InputStream inputStream = null;
        if (this.file != null && this.file.exists()) {
            inputStream = new FileInputStream(this.file);
        } else if (this.url != null) {
            inputStream = this.url.openConnection().getInputStream();
        } else if (this.data != null) {
            inputStream = new ByteArrayInputStream(this.data);
        } else {
            return true;
        }
        byte[] buffer = new byte[4096];
        int nb = 0;
        while ((nb = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, nb);
        }
        out.flush();
        return true;
    }

    protected int getRequestContentLength() {
        if (null != this.data) {
            return this.data.length;
        }
        if (null != this.file && this.file.exists()) {
            return (int)this.file.length();
        }
        if (this.url != null) {
            return -1;
        }
        return 0;
    }

    protected boolean isRequestContentAlreadySet() {
        return this.data != null || this.file != null || this.url != null;
    }

    public void recycle() {
        super.recycle();
        this.data = null;
        this.url = null;
        this.file = null;
    }
}

