/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavState;

public abstract class WebdavSession {
    protected HttpClient client;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected Credentials proxyCredentials = null;
    protected int debug = 0;

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public HttpClient getSessionInstance(HttpURL httpURL) throws IOException {
        return this.getSessionInstance(httpURL, false);
    }

    public HttpClient getSessionInstance(HttpURL httpURL, boolean reset) throws IOException {
        String authority = httpURL.getAuthority();
        if (reset) {
            this.client = null;
        }
        if (this.client == null) {
            String userName;
            this.client = new HttpClient();
            this.client.setState((HttpState)new WebdavState());
            HostConfiguration hostConfig = this.client.getHostConfiguration();
            hostConfig.setHost(httpURL.getHost(), httpURL.getPort(), httpURL.getScheme());
            if (this.proxyHost != null && this.proxyPort > 0) {
                hostConfig.setProxy(this.proxyHost, this.proxyPort);
            }
            if ((userName = httpURL.getUserName()) != null && userName.length() > 0) {
                String password = httpURL.getPassword();
                this.client.getState().setCredentials(null, (Credentials)new UsernamePasswordCredentials(userName, password));
            }
            if (this.proxyCredentials != null) {
                this.client.getState().setProxyCredentials(null, this.proxyCredentials);
            }
        }
        return this.client;
    }

    public void setProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void setProxyCredentials(Credentials credentials) {
        this.proxyCredentials = credentials;
    }

    public void closeSession() throws IOException {
        if (this.client != null) {
            this.client.endSession();
            this.client = null;
        }
    }

    public synchronized void closeSession(HttpClient client) throws IOException {
        this.closeSession();
    }
}

