/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import org.xml.sax.Locator;

public class TreeException
extends RuntimeException
implements Locator {
    private int column = -1;
    private int line = -1;
    private String system_id = null;
    private String public_id = null;
    private Exception exception = null;

    public TreeException(Locator locator, String string) {
        this(locator, string, null);
    }

    public TreeException(Locator locator, Exception exception) {
        this(locator, null, exception);
    }

    public TreeException(Locator locator, String string, Exception exception) {
        super(string == null ? exception.getMessage() : string);
        this.exception = exception;
        if (locator != null) {
            this.public_id = locator.getPublicId();
            this.system_id = locator.getSystemId();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public String getPublicId() {
        return this.public_id;
    }

    public String getSystemId() {
        return this.system_id;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(super.getMessage());
        if (this.system_id != null) {
            stringBuffer.append(" in file \"");
            stringBuffer.append(this.system_id);
            stringBuffer.append('\"');
            if (this.public_id != null) {
                stringBuffer.append(" with public ID \"");
                stringBuffer.append(this.public_id);
                stringBuffer.append('\"');
            }
        }
        if (this.line >= 0) {
            stringBuffer.append(" at line ");
            stringBuffer.append(this.line);
            if (this.column >= 0) {
                stringBuffer.append(" column ");
                stringBuffer.append(this.column);
            }
        }
        stringBuffer.append('.');
        return stringBuffer.toString();
    }
}

