/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.garbage.tree.LocatedEvent;
import org.apache.garbage.tree.Runtime;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TemplateVar
extends LocatedEvent {
    private CompiledExpression expression = null;
    private String data = null;
    private String variable = null;

    public TemplateVar(String string, String string2) {
        this(null, string, string2);
    }

    public TemplateVar(Locator locator, String string, String string2) {
        super(locator);
        if (string == null) {
            throw new TreeException(locator, "No variable name");
        }
        if (string2 == null) {
            throw new TreeException(locator, "No expression data");
        }
        try {
            this.expression = JXPathContext.compile((String)string2);
            this.variable = string;
            this.data = string2;
        }
        catch (Exception exception) {
            throw new TreeException(locator, "Cannot create expression from \"" + string2 + "\"", exception);
        }
    }

    public void process(Runtime runtime, JXPathContext jXPathContext) throws SAXException {
        try {
            Object object = this.expression.getValue(jXPathContext);
            jXPathContext.getVariables().declareVariable(this.variable, object);
        }
        catch (Exception exception) {
            throw new SAXException("Cannot evaluate expression {" + this.data + "}", exception);
        }
    }
}

