/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.garbage.tree.Event;
import org.apache.garbage.tree.Events;
import org.apache.garbage.tree.LocatedEvent;
import org.apache.garbage.tree.LocatedEvents;
import org.apache.garbage.tree.Runtime;
import org.apache.garbage.tree.TreeException;
import org.apache.garbage.tree.VariableScope;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TemplateIf
extends LocatedEvent {
    private ArrayList conditions = new ArrayList();

    public TemplateIf() {
        this(null);
    }

    public TemplateIf(Locator locator) {
        super(locator);
    }

    public Events addCondition(Locator locator) {
        return this.addCondition(locator, null);
    }

    public Events addCondition(Locator locator, String string) {
        Conditional conditional = new Conditional(locator, string);
        this.conditions.add(conditional);
        return conditional;
    }

    public void process(Runtime runtime, JXPathContext jXPathContext) throws SAXException {
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            if (!((Conditional)iterator.next()).process(runtime, jXPathContext)) continue;
            return;
        }
    }

    private static final class Conditional
    extends LocatedEvents {
        private String data = null;
        private CompiledExpression expression = null;

        private Conditional(Locator locator, String string) {
            super(locator);
            if (string != null) {
                try {
                    this.data = "boolean(" + string + ")";
                    this.expression = JXPathContext.compile((String)this.data);
                }
                catch (Exception exception) {
                    throw new TreeException(locator, "Cannot create expression from \"" + string + "\"", exception);
                }
            }
        }

        public boolean process(Runtime runtime, JXPathContext jXPathContext) throws SAXException {
            Object object;
            boolean bl;
            boolean bl2 = bl = this.expression == null;
            if (!bl) {
                try {
                    object = (Boolean)this.expression.getValue(jXPathContext);
                    if (object != null) {
                        bl = (Boolean)object;
                    }
                }
                catch (Exception exception) {
                    throw new SAXException("Cannot evaluate expression {" + this.data + "}", exception);
                }
            }
            if (bl) {
                object = jXPathContext.getContextPointer();
                JXPathContext jXPathContext2 = jXPathContext.getRelativeContext((Pointer)object);
                VariableScope variableScope = new VariableScope(jXPathContext2);
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ((Event)iterator.next()).process(runtime, jXPathContext2);
                }
            }
            return bl;
        }
    }
}

