/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.garbage.tree.Evaluation;
import org.apache.garbage.tree.LocatedEvent;
import org.apache.garbage.tree.Runtime;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Expression
extends LocatedEvent
implements Evaluation {
    private static final char[] nul = new char[]{'n', 'u', 'l', 'l'};
    private CompiledExpression expression = null;
    private String data = null;

    public Expression(String string) {
        this(null, string);
    }

    public Expression(Locator locator, String string) {
        super(locator);
        if (string == null) {
            throw new TreeException(locator, "No expression data");
        }
        try {
            this.expression = JXPathContext.compile((String)string);
            this.data = string;
        }
        catch (Exception exception) {
            throw new TreeException(locator, "Cannot create expression from \"" + string + "\"", exception);
        }
    }

    public String evaluate(JXPathContext jXPathContext) throws SAXException {
        try {
            Object object = this.expression.getValue(jXPathContext);
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        catch (Exception exception) {
            throw new SAXException("Cannot evaluate expression {" + this.data + "}", exception);
        }
    }

    public void process(Runtime runtime, JXPathContext jXPathContext) throws SAXException {
        String string = this.evaluate(jXPathContext);
        if (string == null) {
            runtime.characters(nul);
        } else {
            runtime.characters(string.toCharArray());
        }
    }
}

