/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import java.util.ArrayList;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.garbage.tree.Attribute;
import org.apache.garbage.tree.LocatedEvent;
import org.apache.garbage.tree.Runtime;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ElementStart
extends LocatedEvent {
    private String qualified = "";
    private String prefix = "";
    private String local = "";
    private ArrayList attributes = new ArrayList();
    private ArrayList namespaces = new ArrayList();

    public ElementStart(String string) {
        this(null, string);
    }

    public ElementStart(Locator locator, String string) {
        super(locator);
        if (string == null) {
            throw new TreeException(locator, "No name supplied");
        }
        this.qualified = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            this.prefix = string.substring(0, n);
            this.local = string.substring(n + 1);
            if (this.prefix.length() == 0 || this.local.length() == 0) {
                throw new TreeException(locator, "Invalid \"prefix:name\"");
            }
        } else {
            this.local = string;
        }
    }

    public void put(Attribute attribute) {
        if (attribute == null) {
            throw new TreeException((Locator)this, "Null attribute specified");
        }
        if ("xmlns".equals(attribute.prefix)) {
            if (this.namespaces.contains(attribute)) {
                throw new TreeException((Locator)attribute, "Duplicate namespace prefix \"" + attribute.local + "\" declared for element \"" + (this.prefix != null ? this.prefix + ':' : "") + "\"");
            }
            this.namespaces.add(attribute);
            return;
        }
        if (this.attributes.contains(attribute)) {
            throw new TreeException((Locator)attribute, "Duplicate attribute \"" + (attribute.prefix != null ? attribute.prefix + ':' : "") + attribute.local + "\" declared for element \"" + (this.prefix != null ? this.prefix + ':' : "") + "\"");
        }
        this.attributes.add(attribute);
    }

    public void process(Runtime runtime, JXPathContext jXPathContext) throws SAXException {
        String[][] stringArray = new String[this.attributes.size()][4];
        String[][] stringArray2 = new String[this.namespaces.size()][2];
        int n = 0;
        while (n < this.attributes.size()) {
            Attribute attribute = (Attribute)this.attributes.get(n);
            stringArray[n][0] = attribute.prefix;
            stringArray[n][1] = attribute.local;
            stringArray[n][2] = attribute.qualified;
            stringArray[n][3] = attribute.evaluate(jXPathContext);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.namespaces.size()) {
            Attribute attribute = (Attribute)this.namespaces.get(n2);
            stringArray2[n2][0] = attribute.local;
            stringArray2[n2][1] = attribute.evaluate(jXPathContext);
            ++n2;
        }
        runtime.startElement(this.prefix, this.local, this.qualified, stringArray, stringArray2);
    }
}

