/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import org.apache.garbage.tree.LocatedEvent;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.Locator;

public abstract class DataEvent
extends LocatedEvent {
    private char[] data = null;

    public DataEvent(char c) {
        this(null, c);
    }

    public DataEvent(char[] cArray) {
        this(null, cArray, 0, cArray.length);
    }

    public DataEvent(char[] cArray, int n, int n2) {
        this(null, cArray, n, n2);
    }

    public DataEvent(String string) {
        this(null, string);
    }

    public DataEvent(Locator locator, char c) {
        super(locator);
        this.data = new char[1];
        this.data[0] = c;
    }

    public DataEvent(Locator locator, char[] cArray) {
        this(locator, cArray, 0, cArray.length);
    }

    public DataEvent(Locator locator, char[] cArray, int n, int n2) {
        super(locator);
        try {
            this.data = new char[n2];
            System.arraycopy(cArray, n, this.data, 0, n2);
        }
        catch (Exception exception) {
            throw new TreeException(locator, "Cannot create data event", exception);
        }
    }

    public DataEvent(Locator locator, String string) {
        super(locator);
        if (string == null) {
            throw new TreeException(locator, "Cannot create data event");
        }
        this.data = string.toCharArray();
    }

    protected void mergeData(DataEvent dataEvent) {
        char[] cArray = new char[this.data.length + dataEvent.data.length];
        System.arraycopy(dataEvent.data, 0, cArray, 0, dataEvent.data.length);
        System.arraycopy(this.data, 0, cArray, dataEvent.data.length, this.data.length);
        dataEvent.data = cArray;
        super.mergeLocation(dataEvent);
    }

    protected char[] getArrayValue() {
        char[] cArray = new char[this.data.length];
        System.arraycopy(this.data, 0, cArray, 0, this.data.length);
        return cArray;
    }

    public String getStringValue() {
        return new String(this.data);
    }
}

