/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.garbage.tree.Evaluation;
import org.apache.garbage.tree.Event;
import org.apache.garbage.tree.LocatedEvents;
import org.apache.garbage.tree.TreeException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Attribute
extends LocatedEvents
implements Evaluation {
    protected String qualified = "";
    protected String prefix = "";
    protected String local = "";

    public Attribute(String string) throws TreeException {
        this(null, string);
    }

    public Attribute(Locator locator, String string) throws TreeException {
        super(locator);
        if (string == null) {
            throw new TreeException(locator, "Attribute name cannot be null");
        }
        this.qualified = string;
        int n = string.indexOf(58);
        if (n >= 0) {
            this.prefix = string.substring(0, n);
            this.local = string.substring(n + 1);
            if (this.prefix.length() == 0 || this.local.length() == 0) {
                throw new TreeException(locator, "Invalid \"prefix:name\"");
            }
        } else if ("xmlns".equals(string)) {
            this.prefix = string;
            this.local = "";
        } else {
            this.local = string;
        }
    }

    public void append(Event event) throws TreeException {
        if (event == null) {
            throw new TreeException((Locator)this, "Cannot add null event");
        }
        if (event instanceof Evaluation) {
            super.append(event);
            return;
        }
        throw new TreeException((Locator)this, "Cannot add invalid event type: " + event.getClass().getName());
    }

    public String evaluate(JXPathContext jXPathContext) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Evaluation)iterator.next()).evaluate(jXPathContext));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        return this.qualified.equals(((Attribute)object).qualified);
    }
}

