/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.tree;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.garbage.tree.Event;
import org.apache.garbage.tree.Events;

public class AbstractEvents
implements Events {
    private Event[] events = new Event[1024];
    private int length = 0;

    public synchronized void append(Event event) {
        if (this.length == this.events.length) {
            int n = this.events.length + (this.events.length >> 1);
            Event[] eventArray = new Event[n];
            System.arraycopy(this.events, 0, eventArray, 0, this.length);
            this.events = eventArray;
        }
        if (this.length == 0) {
            this.events[this.length++] = event;
            return;
        }
        if (event.merge(this.events[this.length - 1])) {
            return;
        }
        this.events[this.length++] = event;
    }

    public Iterator iterator() {
        return new EventIterator(this);
    }

    private static final class EventIterator
    implements Iterator {
        private AbstractEvents events = null;
        private int position = 0;

        private EventIterator(AbstractEvents abstractEvents) {
            this.events = abstractEvents;
        }

        public boolean hasNext() {
            return this.position < this.events.length;
        }

        public Object next() {
            if (this.position < this.events.length) {
                return this.events.events[this.position++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

