/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.garbage.serializer.HTMLSerializer;
import org.apache.garbage.serializer.encoding.CharsetFactory;

public class GarbageServlet
extends HttpServlet {
    private ServletContext context = null;
    private ServletConfig config = null;
    private String charset = null;

    public void init() throws ServletException {
        this.context = this.getServletContext();
        this.config = this.getServletConfig();
        this.charset = this.config.getInitParameter("charset");
        try {
            CharsetFactory charsetFactory = CharsetFactory.newInstance();
            this.charset = charsetFactory.getCharset(this.charset).getName();
        }
        catch (Throwable throwable) {
            throw new ServletException("Unable to set up default charset \"" + this.charset + "\"", throwable);
        }
        this.log("GarbageServlet initialized (charset=" + this.charset + ")");
    }

    public void destroy() {
        this.log("GarbageServlet destroyed");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        URL uRL;
        long l = System.currentTimeMillis();
        String string = httpServletRequest.getServletPath();
        if (httpServletRequest.getPathInfo() != null) {
            string = string + httpServletRequest.getPathInfo();
        }
        if ((uRL = this.getServletContext().getResource(string)) == null) {
            httpServletResponse.sendError(404, "Unable to locate template \"" + string + "\" in application context.");
            return;
        }
        HTMLSerializer hTMLSerializer = new HTMLSerializer();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        hTMLSerializer.setOutput((OutputStream)servletOutputStream, this.charset);
        String string2 = hTMLSerializer.getContentType();
        httpServletResponse.setContentType(hTMLSerializer.getContentType());
        servletOutputStream.println("<HTML><BODY>&quot;" + uRL + "&quot;</BODY></HTML>");
        servletOutputStream.flush();
        this.log("Template \"" + string + "\" written as \"" + string2 + "\"" + " in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " seconds.");
    }
}

