/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer.encoding;

import org.apache.garbage.serializer.encoding.CompiledEncoder;

public class XMLEncoder
extends CompiledEncoder {
    private static final char[] ENCODE_HEX = "0123456789ABCDEF".toCharArray();
    private static final char[] ENCODE_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODE_AMP = "&amp;".toCharArray();
    private static final char[] ENCODE_APOS = "&apos;".toCharArray();
    private static final char[] ENCODE_LT = "&lt;".toCharArray();
    private static final char[] ENCODE_GT = "&gt;".toCharArray();

    public XMLEncoder() {
        super("X-W3C-XML");
    }

    protected boolean compile(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        return c != '\"' && c != '&' && c != '\'' && c != '<' && c != '>' && c >= ' ' && (c <= '\ud7ff' || c >= '\ue000') && c <= '\ufffd';
    }

    public char[] encode(char c) {
        switch (c) {
            case '\"': {
                return ENCODE_QUOT;
            }
            case '&': {
                return ENCODE_AMP;
            }
            case '\'': {
                return ENCODE_APOS;
            }
            case '<': {
                return ENCODE_LT;
            }
            case '>': {
                return ENCODE_GT;
            }
        }
        if (c > '\u0fff') {
            char[] cArray = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 12 & 0xF], ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
            return cArray;
        }
        if (c > '\u00ff') {
            char[] cArray = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 8 & 0xF], ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
            return cArray;
        }
        char[] cArray = new char[]{'&', '#', 'x', ENCODE_HEX[c >> 4 & 0xF], ENCODE_HEX[c & 0xF], ';'};
        return cArray;
    }
}

