/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer.encoding;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Iterator;
import org.apache.garbage.serializer.encoding.CompiledCharset;

public class Compiler
extends CompiledCharset {
    private String clazz = null;
    private CharsetEncoder encoder = null;

    private Compiler(String string, String[] stringArray, CharsetEncoder charsetEncoder) {
        super(string, stringArray);
        this.clazz = "cs_" + string.replace('-', '_').toUpperCase();
        this.encoder = charsetEncoder;
        this.compile();
    }

    protected boolean compile(char c) {
        return this.encoder.canEncode(c);
    }

    public void save() throws IOException {
        this.save(new File(System.getProperty("user.dir")));
    }

    public void save(File file) throws IOException {
        File file2 = new File(file, this.clazz + ".java");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.save(fileOutputStream);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public void save(OutputStream outputStream) throws IOException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
        printStream.println("/* ============================================================================ *");
        printStream.println(" *                   The Apache Software License, Version 1.1                   *");
        printStream.println(" * ============================================================================ *");
        printStream.println(" *                                                                              *");
        printStream.println(" * Copyright (C) 1999-2003 The Apache Software Foundation. All rights reserved. *");
        printStream.println(" *                                                                              *");
        printStream.println(" * Redistribution and use in source and binary forms, with or without modifica- *");
        printStream.println(" * tion, are permitted provided that the following conditions are met:          *");
        printStream.println(" *                                                                              *");
        printStream.println(" * 1. Redistributions of  source code must  retain the above copyright  notice, *");
        printStream.println(" *    this list of conditions and the following disclaimer.                     *");
        printStream.println(" *                                                                              *");
        printStream.println(" * 2. Redistributions in binary form must reproduce the above copyright notice, *");
        printStream.println(" *    this list of conditions and the following disclaimer in the documentation *");
        printStream.println(" *    and/or other materials provided with the distribution.                    *");
        printStream.println(" *                                                                              *");
        printStream.println(" * 3. The end-user documentation included with the redistribution, if any, must *");
        printStream.println(" *    include  the following  acknowledgment:  \"This product includes  software *");
        printStream.println(" *    developed  by the  Apache Software Foundation  (http://www.apache.org/).\" *");
        printStream.println(" *    Alternately, this  acknowledgment may  appear in the software itself,  if *");
        printStream.println(" *    and wherever such third-party acknowledgments normally appear.            *");
        printStream.println(" *                                                                              *");
        printStream.println(" * 4. The names \"Apache Cocoon\" and  \"Apache Software Foundation\" must  not  be *");
        printStream.println(" *    used to  endorse or promote  products derived from  this software without *");
        printStream.println(" *    prior written permission. For written permission, please contact          *");
        printStream.println(" *    apache@apache.org.                                                        *");
        printStream.println(" *                                                                              *");
        printStream.println(" * 5. Products  derived from this software may not  be called \"Apache\", nor may *");
        printStream.println(" *    \"Apache\" appear  in their name,  without prior written permission  of the *");
        printStream.println(" *    Apache Software Foundation.                                               *");
        printStream.println(" *                                                                              *");
        printStream.println(" * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, *");
        printStream.println(" * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND *");
        printStream.println(" * FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE *");
        printStream.println(" * APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT, *");
        printStream.println(" * INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU- *");
        printStream.println(" * DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS *");
        printStream.println(" * OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON *");
        printStream.println(" * ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT *");
        printStream.println(" * (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF *");
        printStream.println(" * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.            *");
        printStream.println(" *                                                                              *");
        printStream.println(" * This software  consists of voluntary contributions made  by many individuals *");
        printStream.println(" * on  behalf of the Apache Software  Foundation.  For more  information on the *");
        printStream.println(" * Apache Software Foundation, please see <http://www.apache.org/>.             *");
        printStream.println(" *                                                                              *");
        printStream.println(" * ============================================================================ */");
        printStream.println("/* Generated by " + this.getClass().getName() + " */");
        printStream.println();
        printStream.println("package org.apache.garbage.serializer.encoding;");
        printStream.println();
        printStream.println("/**");
        printStream.println(" * The <b>" + this.getName() + "</b> character set encoding representation.");
        printStream.println(" *");
        printStream.println(" * @author Generated by <code>" + this.getClass().getName() + "</code>");
        printStream.println(" */");
        printStream.println("class " + this.clazz + " extends CompiledCharset {");
        printStream.println();
        printStream.println("    /** The name of this charset (<b>" + this.getName() + "</b>). */");
        printStream.println("    public static final String CS_NAME = \"" + this.getName() + "\";");
        printStream.println();
        printStream.println("    /** The array of alias names of this charset. */");
        printStream.println("    public static final String CS_ALIASES[] = {");
        String[] stringArray = this.getAliases();
        int n = 0;
        while (n < stringArray.length) {
            printStream.println("        \"" + stringArray[n] + "\",");
            ++n;
        }
        printStream.println("    };");
        printStream.println();
        printStream.println("    /** The array all characters encoded by this encoding. */");
        printStream.print("    public static final byte CS_ENCODING[] = {");
        int n2 = 0;
        while (n2 < this.encoding.length) {
            if ((n2 & 0xF) == 0) {
                printStream.println();
                printStream.print("       ");
            }
            String string = Integer.toString(this.encoding[n2]);
            string = "    ".substring(string.length()) + string;
            printStream.print(string);
            if (n2 + 1 != this.encoding.length) {
                printStream.print(",");
            }
            ++n2;
        }
        printStream.println();
        printStream.println("    };");
        printStream.println();
        printStream.println("    /**");
        printStream.println("     * Create a new instance of the <b>" + this.getName() + "</b> caracter");
        printStream.println("     * encoding as a <code>Charset</code>.");
        printStream.println("     */");
        printStream.println("    public " + this.clazz + "() {");
        printStream.println("        super(CS_NAME, CS_ALIASES, CS_ENCODING);");
        printStream.println("    }");
        printStream.println();
        printStream.println("    /**");
        printStream.println("     * Operation not supported.");
        printStream.println("     */");
        printStream.println("    public boolean compile(char c) {");
        printStream.println("        throw new UnsupportedOperationException();");
        printStream.println("    }");
        printStream.println();
        printStream.println("}");
        printStream.flush();
    }

    public static Compiler process(Charset charset) throws IOException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        String string = charset.displayName();
        String[] stringArray = new String[charset.aliases().size()];
        Iterator<String> iterator = charset.aliases().iterator();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = iterator.next().toString();
            ++n;
        }
        return new Compiler(string, stringArray, charsetEncoder);
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File(System.getProperty("user.dir"));
        if (stringArray.length > 0) {
            file = new File(stringArray[0]);
        }
        if (!file.isDirectory()) {
            throw new IOException("Invalid output directory \"" + file.getName() + "\"");
        }
        Collection<Charset> collection = Charset.availableCharsets().values();
        Iterator<Charset> iterator = collection.iterator();
        int n = 0;
        int n2 = collection.size();
        while (iterator.hasNext()) {
            Charset charset = iterator.next();
            Compiler compiler = Compiler.process(charset);
            compiler.save(file);
            System.out.println("Generating \"" + compiler.clazz + ".java\" " + "for \"" + compiler.getName() + "\" charset (" + ++n + " of " + n2 + ")");
        }
    }
}

