/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer.encoding;

import org.apache.garbage.serializer.encoding.AbstractCharset;

public abstract class CompiledCharset
extends AbstractCharset {
    protected byte[] encoding;

    protected CompiledCharset(String string, String[] stringArray) {
        super(string, stringArray);
        this.encoding = new byte[8192];
        int n = 0;
        while (n < this.encoding.length) {
            this.encoding[n] = 0;
            ++n;
        }
    }

    protected CompiledCharset(String string, String[] stringArray, byte[] byArray) throws NullPointerException, IllegalArgumentException {
        super(string, stringArray);
        if (byArray == null) {
            throw new NullPointerException("Invalid table");
        }
        if (byArray.length != 8192) {
            throw new IllegalArgumentException("Invalid encoding table size: current length is " + byArray.length + ", required 8192.");
        }
        this.encoding = byArray;
    }

    public boolean allows(char c) {
        return (this.encoding[c >> 3] & 1 << (c & 7)) > 0;
    }

    protected final void compile() {
        int n = 0;
        while (n <= 65535) {
            if (this.compile((char)n)) {
                int n2 = n >> 3;
                this.encoding[n2] = (byte)(this.encoding[n2] | 1 << (n & 7));
            }
            ++n;
        }
    }

    protected abstract boolean compile(char var1);
}

