/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer.encoding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.garbage.serializer.encoding.Charset;
import org.apache.garbage.serializer.encoding.UnknownCharset;

public final class CharsetFactory {
    private static CharsetFactory instance = new CharsetFactory();
    private Charset defaultCharset = null;
    private Charset unknownCharset = null;
    private HashMap charsets = new HashMap();
    static /* synthetic */ Class class$org$apache$garbage$serializer$encoding$CharsetFactory;

    private CharsetFactory() {
        this.unknownCharset = new UnknownCharset();
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = this.getClass().getName().replace('.', '/') + ".class";
        URL uRL = classLoader.getResource(string);
        if ("jar".equals(uRL.getProtocol())) {
            this.loadCharsetsFromJar(uRL);
        } else if ("file".equals(uRL.getProtocol())) {
            this.loadCharsetsFromFile(uRL);
        } else {
            throw new CharsetFactoryException("Unable to load charsets from protocol \"" + uRL.getProtocol() + "\"", null);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        String string2 = outputStreamWriter.getEncoding();
        try {
            this.defaultCharset = this.getCharset(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CharsetFactoryException("The default encoding of this JVM \"" + string2 + "\" is not supported", unsupportedEncodingException);
        }
    }

    private void loadCharset(Charset charset) {
        this.charsets.put(charset.getName().toLowerCase(), charset);
        String[] stringArray = charset.getAliases();
        int n = 0;
        while (n < stringArray.length) {
            this.charsets.put(stringArray[n].toLowerCase(), charset);
            ++n;
        }
    }

    private void loadCharset(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof Charset) {
                this.loadCharset((Charset)obj);
            }
        }
        catch (Exception exception) {
            throw new CharsetFactoryException("Unable to instantiate class \"" + string + "\"", exception);
        }
    }

    private void loadCharsetsFromJar(URL uRL) {
        try {
            String string = uRL.getFile();
            String string2 = string.substring(string.indexOf(33));
            string = string.substring(5, string.indexOf(33));
            string2 = string2.substring(2, string2.lastIndexOf(47) + 1) + "cs_";
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (!string3.startsWith(string2) || !string3.endsWith(".class")) continue;
                string3 = string3.substring(string2.length());
                string3 = ".cs_" + string3.substring(0, string3.length() - 6);
                string3 = this.getClass().getPackage().getName() + string3;
                this.loadCharset(string3);
            }
        }
        catch (IOException iOException) {
            throw new CharsetFactoryException("Unable to access JAR \"" + uRL.toString() + "\"", iOException);
        }
    }

    private void loadCharsetsFromFile(URL uRL) {
        File file = new File(uRL.getFile()).getParentFile();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("cs_") && string.endsWith(".class")) {
                string = '.' + string.substring(0, string.length() - 6);
                string = this.getClass().getPackage().getName() + string;
                this.loadCharset(string);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharsetFactory newInstance() {
        if (instance != null) {
            return instance;
        }
        Class clazz = class$org$apache$garbage$serializer$encoding$CharsetFactory == null ? (class$org$apache$garbage$serializer$encoding$CharsetFactory = CharsetFactory.class$("org.apache.garbage.serializer.encoding.CharsetFactory")) : class$org$apache$garbage$serializer$encoding$CharsetFactory;
        synchronized (clazz) {
            if (instance != null) {
                return instance;
            }
            instance = new CharsetFactory();
        }
        return instance;
    }

    public Charset getCharset() {
        return this.unknownCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset getCharset(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return this.getDefaultCharset();
        }
        Charset charset = (Charset)this.charsets.get(string.toLowerCase());
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedEncodingException("Unsupported charset \"" + string + "\"");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CharsetFactoryException
    extends RuntimeException {
        private Exception exception = null;

        private CharsetFactoryException(String string, Exception exception) {
            super(string == null ? exception.getMessage() : string);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            if (this.exception != null) {
                printWriter.print("Root cause: ");
                this.exception.printStackTrace(printWriter);
            }
        }

        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            if (this.exception != null) {
                printStream.print("Root cause: ");
                this.exception.printStackTrace(printStream);
            }
        }
    }
}

