/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer;

import java.io.CharArrayWriter;
import org.apache.garbage.serializer.EncodingSerializer;
import org.apache.garbage.serializer.encoding.Encoder;
import org.apache.garbage.serializer.encoding.XMLEncoder;
import org.apache.garbage.serializer.util.DocType;
import org.xml.sax.SAXException;

public class XMLSerializer
extends EncodingSerializer {
    private static final XMLEncoder XML_ENCODER = new XMLEncoder();
    private static final char[] S_EOL = System.getProperty("line.separator").toCharArray();
    private static final char[] S_DOCUMENT_1 = "<?xml version=\"1.0".toCharArray();
    private static final char[] S_DOCUMENT_2 = "\" encoding=\"".toCharArray();
    private static final char[] S_DOCUMENT_3 = "\"?>".toCharArray();
    private static final char[] S_DOCTYPE_1 = "<!DOCTYPE ".toCharArray();
    private static final char[] S_DOCTYPE_2 = " PUBLIC \"".toCharArray();
    private static final char[] S_DOCTYPE_3 = "\" \"".toCharArray();
    private static final char[] S_DOCTYPE_4 = " SYSTEM \"".toCharArray();
    private static final char[] S_DOCTYPE_5 = "\">".toCharArray();
    private static final char[] S_ELEMENT_1 = "=\"".toCharArray();
    private static final char[] S_ELEMENT_2 = "</".toCharArray();
    private static final char[] S_ELEMENT_3 = " />".toCharArray();
    private static final char[] S_ELEMENT_4 = " xmlns".toCharArray();
    private static final char[] S_CDATA_1 = "<[CDATA[".toCharArray();
    private static final char[] S_CDATA_2 = "]]>".toCharArray();
    private static final char[] S_COMMENT_1 = "<!--".toCharArray();
    private static final char[] S_COMMENT_2 = "-->".toCharArray();
    private static final char[] S_PROCINSTR_1 = "<?".toCharArray();
    private static final char[] S_PROCINSTR_2 = "?>".toCharArray();
    private static final char C_LT = '<';
    private static final char C_GT = '>';
    private static final char C_SPACE = ' ';
    private static final char C_QUOTE = '\"';
    private static final char C_NSSEP = ':';
    private static final boolean DEBUG = false;
    private boolean hanging_element = false;
    private boolean processing_prolog = true;
    private boolean processing_dtd = false;
    private PrologWriter prolog = new PrologWriter();
    protected DocType doctype = null;

    public XMLSerializer() {
        this(XML_ENCODER);
    }

    public XMLSerializer(Encoder encoder) {
        super(encoder);
    }

    public void reset() {
        super.reset();
        this.doctype = null;
        this.hanging_element = false;
        this.processing_prolog = true;
        this.processing_dtd = false;
        if (this.prolog != null) {
            this.prolog.reset();
        }
    }

    public String getContentType() {
        if (this.encoding == null) {
            return "text/xml";
        }
        return "text/xml; charset=" + this.encoding;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.head();
    }

    public void endDocument() throws SAXException {
        this.writeln();
        super.endDocument();
    }

    protected void head() throws SAXException {
        this.write(S_DOCUMENT_1);
        if (this.encoding != null) {
            this.write(S_DOCUMENT_2);
            this.write(this.encoding);
        }
        this.write(S_DOCUMENT_3);
        this.writeln();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.processing_dtd = true;
        this.doctype = new DocType(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.processing_dtd = false;
    }

    public void body(String string, String string2, String string3) throws SAXException {
        this.processing_prolog = false;
        this.writeln();
        if (this.doctype != null) {
            String string4 = this.doctype.getName();
            String string5 = this.doctype.getPublicId();
            String string6 = this.doctype.getSystemId();
            if (!string4.equals(string3)) {
                throw new SAXException("Root element name \"" + string4 + "\" declared by document type declaration differs " + "from actual root element name \"" + string3 + "\"");
            }
            this.write(S_DOCTYPE_1);
            this.write(string4);
            if (string5 != null) {
                this.write(S_DOCTYPE_2);
                this.write(string5);
                this.write(S_DOCTYPE_3);
                this.write(string6);
                this.write(S_DOCTYPE_5);
            } else if (string6 != null) {
                this.write(S_DOCTYPE_4);
                this.write(string6);
                this.write(S_DOCTYPE_5);
            } else {
                this.write(62);
            }
            this.writeln();
        }
        this.prolog.writeTo(this);
        this.writeln();
    }

    public void startElementImpl(String string, String string2, String string3, String[][] stringArray, String[][] stringArray2) throws SAXException {
        this.closeElement(false);
        this.write(60);
        this.write(string3);
        int n = 0;
        while (n < stringArray.length) {
            this.write(S_ELEMENT_4);
            if (stringArray[n][0].length() > 0) {
                this.write(58);
                this.write(stringArray[n][0]);
            }
            this.write(S_ELEMENT_1);
            this.encode(stringArray[n][1]);
            this.write(34);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.write(32);
            this.write(stringArray2[n2][2]);
            this.write(S_ELEMENT_1);
            this.encode(stringArray2[n2][3]);
            this.write(34);
            ++n2;
        }
        this.hanging_element = true;
    }

    public void endElementImpl(String string, String string2, String string3) throws SAXException {
        if (this.closeElement(true)) {
            return;
        }
        this.write(S_ELEMENT_2);
        this.write(string3);
        this.write(62);
    }

    protected boolean closeElement(boolean bl) throws SAXException {
        if (!this.hanging_element) {
            return false;
        }
        if (bl) {
            this.write(S_ELEMENT_3);
        } else {
            this.write(62);
        }
        this.hanging_element = false;
        return true;
    }

    public void startCDATA() throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.write(S_CDATA_1);
    }

    public void endCDATA() throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.write(S_CDATA_2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.encode(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.processing_dtd) {
            return;
        }
        if (this.processing_prolog) {
            this.prolog.write(S_COMMENT_1);
            this.prolog.write(cArray, n, n2);
            this.prolog.write(S_COMMENT_2);
            this.prolog.write(S_EOL);
            return;
        }
        this.closeElement(false);
        this.write(S_COMMENT_1);
        this.write(cArray, n, n2);
        this.write(S_COMMENT_2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.processing_dtd) {
            return;
        }
        if (this.processing_prolog) {
            this.prolog.write(S_PROCINSTR_1);
            this.prolog.write(string);
            if (string2 != null) {
                this.prolog.write(32);
                this.prolog.write(string2);
            }
            this.prolog.write(S_PROCINSTR_2);
            this.prolog.write(S_EOL);
            return;
        }
        this.closeElement(false);
        this.write(S_PROCINSTR_1);
        this.write(string);
        if (string2 != null) {
            this.write(32);
            this.write(string2);
        }
        this.write(S_PROCINSTR_2);
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    private static final class PrologWriter
    extends CharArrayWriter {
        private PrologWriter() {
        }

        public void write(char[] cArray) {
            this.write(cArray, 0, cArray.length);
        }

        public void write(String string) {
            this.write(string, 0, string.length());
        }

        public void writeTo(XMLSerializer xMLSerializer) throws SAXException {
            xMLSerializer.write(this.buf, 0, this.count);
        }
    }
}

