/*
 * Decompiled with CFR 0.152.
 */
package org.apache.garbage.serializer;

import org.apache.garbage.serializer.AbstractSerializer;
import org.apache.garbage.serializer.encoding.DefaultEncoder;
import org.apache.garbage.serializer.encoding.Encoder;
import org.xml.sax.SAXException;

public abstract class EncodingSerializer
extends AbstractSerializer {
    private Encoder encoder = null;

    public EncodingSerializer() {
        this(new DefaultEncoder());
    }

    public EncodingSerializer(Encoder encoder) {
        this.encoder = encoder;
    }

    protected void encode(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.encode(cArray, 0, cArray.length);
    }

    protected void encode(char[] cArray) throws SAXException {
        this.encode(cArray, 0, cArray.length);
    }

    protected void encode(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n + n2;
        if (cArray == null) {
            throw new NullPointerException("Null data");
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n3 > cArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException("Invalid data");
        }
        if (n2 == 0) {
            return;
        }
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (!this.charset.allows(c) || !this.encoder.allows(c)) {
                if (n != n4) {
                    this.write(cArray, n, n4 - n);
                }
                this.write(this.encoder.encode(c));
                n = n4 + 1;
            }
            ++n4;
        }
        if (n != n3) {
            this.write(cArray, n, n3 - n);
        }
    }
}

